<?xml version="1.0" encoding="UTF-8"?>
<SCL xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.iec.ch/61850/2003/SCL" xmlns:eComm="http://www.abb.com/61850/2015/SCL_ABBCommunication" xmlns:sxy="http://www.iec.ch/61850/2003/SCLcoordinates" revision="B" version="2007">
  <Header id="IEC61850WeekDemo" nameStructure="IEDName" revision="R000" toolID="Helinks STS 3.8.0.0" version="V1">
    <History>
      <Hitem revision="R000" version="V1" what="Starting Point" when="Tue Mar 07 12:46:42 CET 2023" who="JR" why="Helinks STS Top Down Demo"/>
    </History>
  </Header>
  <Substation sxy:x="14" desc="Library Project" name="Raleigh">
    <PowerTransformer sxy:x="6" name="T1" type="PTR">
      <TransformerWinding name="W1" type="PTW"/>
      <TransformerWinding name="W2" type="PTW">
        <Terminal bayName="02" cNodeName="CN_5c6dcbe7-8fa1-46fd-8e3f-0c14c2893a4f" connectivityNode="Berlin/E/02/CN_5c6dcbe7-8fa1-46fd-8e3f-0c14c2893a4f" name="TW" substationName="Berlin" voltageLevelName="E"/>
        <Terminal bayName="02" cNodeName="CN_3b3671e2-46b6-46d6-941d-515419464823" connectivityNode="Cardiff/E/02/CN_3b3671e2-46b6-46d6-941d-515419464823" name="TW" substationName="Cardiff" voltageLevelName="E"/>
        <Terminal bayName="02" cNodeName="CN_21a1369e-1904-4516-8e27-aefec11ca1bd" connectivityNode="Raleigh/E/02/CN_21a1369e-1904-4516-8e27-aefec11ca1bd" name="TW" substationName="Raleigh" voltageLevelName="E"/>
      </TransformerWinding>
    </PowerTransformer>
    <PowerTransformer sxy:x="29" name="T2" type="PTR">
      <TransformerWinding name="W1" type="PTW"/>
      <TransformerWinding name="W2" type="PTW">
        <Terminal bayName="05" cNodeName="CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5" connectivityNode="Raleigh/E/05/CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5" name="TW" substationName="Raleigh" voltageLevelName="E"/>
      </TransformerWinding>
    </PowerTransformer>
    <VoltageLevel sxy:y="2" name="E">
      <Voltage multiplier="k" unit="V">110</Voltage>
      <Bay sxy:y="8" name="BB">
        <Private source="HELINKS LLC" type="IS_BUSBAR"/>
        <ConnectivityNode name="L1" pathName="Raleigh/E/BB/L1"/>
      </Bay>
      <Bay sxy:x="26" sxy:y="9" name="LineFeeder">
        <ConductingEquipment sxy:x="1" name="QB1" type="DIS">
          <Terminal bayName="01" cNodeName="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" connectivityNode="Berlin/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" name="T2" substationName="Berlin" voltageLevelName="E"/>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Raleigh/E/BB/L1" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <EqFunction name="Control"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="3" name="QA0" type="CBR">
          <Terminal bayName="01" cNodeName="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" connectivityNode="Berlin/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" name="T1" substationName="Berlin" voltageLevelName="E"/>
          <Terminal bayName="01" cNodeName="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" connectivityNode="Berlin/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" name="T2" substationName="Berlin" voltageLevelName="E"/>
          <EqFunction name="Control"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="6" name="CT" type="CTR">
          <Terminal bayName="01" cNodeName="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" connectivityNode="Berlin/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" name="T1" substationName="Berlin" voltageLevelName="E"/>
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Berlin/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T2" substationName="Berlin" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A"/>
          <SubEquipment name="L2" phase="B"/>
          <SubEquipment name="L3" phase="C"/>
          <SubEquipment name="L4" phase="N"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:y="8" name="VT" type="VTR">
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Berlin/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T1" substationName="Berlin" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A"/>
          <SubEquipment name="L2" phase="B"/>
          <SubEquipment name="L3" phase="C"/>
          <SubEquipment name="L4" phase="N"/>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="10" name="Line" type="IFL">
          <Terminal bayName="01" cNodeName="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" connectivityNode="Berlin/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" name="T1" substationName="Berlin" voltageLevelName="E"/>
        </ConductingEquipment>
        <ConnectivityNode name="grounded" pathName="Cardiff/E/01/grounded"/>
        <ConnectivityNode name="CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35" pathName="Cardiff/E/01/CN_cd1cb713-93ab-4344-ab41-2c3ae0f4ca35"/>
        <ConnectivityNode name="CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d" pathName="Cardiff/E/01/CN_e48f2296-5d55-4dca-b2e7-1d18ef558a6d"/>
        <ConnectivityNode name="CN_0b4d0fd0-4a03-4f55-931b-5765479d376c" pathName="Cardiff/E/01/CN_0b4d0fd0-4a03-4f55-931b-5765479d376c"/>
        <Function name="Measurement"/>
        <Function name="Distance"/>
        <Function name="Overcurrent"/>
        <Function name="Trip"/>
        <Function name="BreakerFailure"/>
      </Bay>
      <Bay sxy:x="1" sxy:y="9" name="01">
        <ConductingEquipment sxy:x="1" name="QB1" type="DIS">
          <LNode iedName="E01PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Raleigh/E/BB/L1" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="2" name="QA0" type="CBR">
          <LNode iedName="E01PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="5" name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment sxy:y="8" name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="1" sxy:y="10" name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Raleigh/E/01/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E01PIU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
      </Bay>
      <Bay sxy:y="8" name="02">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E02PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Raleigh/E/BB/L1" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E02PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <Terminal bayName="02" cNodeName="CN_21a1369e-1904-4516-8e27-aefec11ca1bd" connectivityNode="Raleigh/E/02/CN_21a1369e-1904-4516-8e27-aefec11ca1bd" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E02PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <Terminal bayName="02" cNodeName="CN_21a1369e-1904-4516-8e27-aefec11ca1bd" connectivityNode="Raleigh/E/02/CN_21a1369e-1904-4516-8e27-aefec11ca1bd" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E02PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConnectivityNode name="grounded" pathName="Raleigh/E/02/grounded"/>
        <ConnectivityNode name="CN_21a1369e-1904-4516-8e27-aefec11ca1bd" pathName="Raleigh/E/02/CN_21a1369e-1904-4516-8e27-aefec11ca1bd"/>
        <Function name="Measurement">
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Differential">
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" lnType="pdif_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E02PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
      </Bay>
      <Bay sxy:y="8" name="03">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E03PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Raleigh/E/BB/L1" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E03PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E03PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E03PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Raleigh/E/03/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E03PIU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
      </Bay>
      <Bay sxy:y="8" name="04">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E04PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Raleigh/E/BB/L1" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E04PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E04PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E04PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Raleigh/E/04/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E04PIU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
      </Bay>
      <Bay sxy:x="27" name="05">
        <ConductingEquipment sxy:x="2" sxy:y="6" name="QB1" type="DIS">
          <LNode iedName="E05PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Raleigh/E/BB/L1" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="2" sxy:y="4" name="QA0" type="CBR">
          <LNode iedName="E05PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <Terminal bayName="05" cNodeName="CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5" connectivityNode="Raleigh/E/05/CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E05PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment sxy:x="2" sxy:y="1" name="CT" type="CTR">
          <Terminal bayName="05" cNodeName="CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5" connectivityNode="Raleigh/E/05/CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E05PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConnectivityNode name="grounded" pathName="Raleigh/E/05/grounded"/>
        <ConnectivityNode name="CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5" pathName="Raleigh/E/05/CN_2b08be94-d86d-4c8c-80ca-d1ed4f29d7d5"/>
        <Function name="Measurement">
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Differential">
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" lnType="pdif_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E05PIU" ldInst="Trip" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
      </Bay>
      <Bay sxy:y="8" name="06">
        <ConductingEquipment name="QB1" type="DIS">
          <LNode iedName="E06PIU" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" lnType="xswi_7_4_B2007" prefix="QB1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <Terminal bayName="BB" cNodeName="L1" connectivityNode="Raleigh/E/BB/L1" name="T1" substationName="Raleigh" voltageLevelName="E"/>
          <EqFunction name="Control">
            <LNode iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" lnType="cswi_7_4_B2007" prefix="QB1">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="QA0" type="CBR">
          <LNode iedName="E06PIU" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" lnType="xcbr_7_4_B2007" prefix="QA0">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <EqFunction name="Control">
            <LNode iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" lnType="cswi_7_4_B2007" prefix="QA0">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </EqFunction>
        </ConductingEquipment>
        <ConductingEquipment name="CT" type="CTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E06PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="VT" type="VTR">
          <SubEquipment name="L1" phase="A">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="A">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L2" phase="B">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="B">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="L3" phase="C">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="C">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
          <SubEquipment name="Neut" phase="N">
            <LNode iedName="E06PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="N">
              <Private type="eIEC61850-6-100"/>
            </LNode>
          </SubEquipment>
        </ConductingEquipment>
        <ConductingEquipment name="Line" type="IFL"/>
        <ConnectivityNode name="grounded" pathName="Raleigh/E/06/grounded"/>
        <Function name="Measurement">
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" lnType="mmxu_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" lnType="mmxu_7_4_B2007" prefix="V">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="2" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="12" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="14" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TVTR" lnInst="3" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BCU" ldInst="Measurement" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Distance">
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" lnType="pdis_7_4_B2007" prefix="Z1">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" lnType="pdis_7_4_B2007" prefix="Z2">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" lnType="pdis_7_4_B2007" prefix="Z3">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="DIS">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" lnType="tvtr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" lnType="tvtr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" lnType="tvtr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" lnType="tvtr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Overcurrent">
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" lnType="ptoc_7_4_B2007" prefix="PH">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" lnType="tctr_7_4_B2007" prefix="A">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" lnType="tctr_7_4_B2007" prefix="B">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" lnType="tctr_7_4_B2007" prefix="C">
            <Private type="eIEC61850-6-100"/>
          </LNode>
          <LNode iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" lnType="tctr_7_4_B2007" prefix="N">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="Trip">
          <LNode iedName="E06PIU" ldInst="LD0" lnClass="PTRC" lnInst="1" lnType="ptrc_7_4_B2007" prefix="Trip">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
        <Function name="BreakerFailure">
          <LNode iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" lnType="rbrf_7_4_B2007" prefix="">
            <Private type="eIEC61850-6-100"/>
          </LNode>
        </Function>
      </Bay>
    </VoltageLevel>
    <Function name="HMI">
      <LNode iedName="Zenon" ldInst="HMI" lnClass="ITCI" lnInst="1" lnType="ITCI_ZENON" prefix="">
        <Private type="eIEC61850-6-100"/>
      </LNode>
    </Function>
    <Function name="NCC">
      <LNode iedName="XPG" ldInst="LD0" lnClass="ITCI" lnInst="1" lnType="itci_7_4_B2007" prefix="">
        <Private type="eIEC61850-6-100"/>
      </LNode>
    </Function>
  </Substation>
  <Communication>
    <SubNetwork name="StationBus" type="8-MMS">
      <ConnectedAP apName="S1" iedName="Zenon">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="XPG">
        <Address>
          <P type="IP">10.10.0.2</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E04BCU">
        <Address>
          <P type="IP">192.168.0.7</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Measurement">
          <Private source="1704789725806" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1704789725807" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Measurement">
          <Private source="1704789725807" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E01BUP">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E01BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">172.24.7.111</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">172.24.7.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Measurement">
          <Private source="1704789725805" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1704789725805" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Measurement">
          <Private source="1704789725805" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E02BCU">
        <Address>
          <P type="IP">127.0.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,1</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">127.0.0.0</P>
          <P type="OSI-AE-Qualifier">12</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="GoCB01" ldInst="Measurement">
          <Private source="1704789725815" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB02" ldInst="Measurement">
          <Private source="1704789725815" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB03" ldInst="Measurement">
          <Private source="1704789725816" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E01BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.254</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">192.168.2.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725797" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.16.60.65</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Differential">
          <Private source="1704789725811" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02BUP">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.16.60.65</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">0.0.0.0</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Overcurrent">
          <Private source="1704789725808" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E03BUP">
        <Address>
          <P type="IP">192.168.0.3</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E03BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Measurement">
          <Private source="1704789725810" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1704789725810" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Measurement">
          <Private source="1704789725810" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E04BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.8</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725822" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E04BUP">
        <Address>
          <P type="IP">192.168.0.9</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.5</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Differential">
          <Private source="1704789725823" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05BUP">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.6</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Overcurrent">
          <Private source="1704789725801" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E05BCU">
        <Address>
          <P type="IP">192.168.0.4</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="GoCB01" ldInst="Measurement">
          <Private source="1704789725812" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB02" ldInst="Measurement">
          <Private source="1704789725812" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="GoCB03" ldInst="Measurement">
          <Private source="1704789725812" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E06BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.11</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725824" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E06BUP">
        <Address>
          <P type="IP">192.168.0.12</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb01" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb02" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb03" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb04" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb05" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb06" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb07" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb08" ldInst="System">
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-ID">000</P>
            <P type="VLAN-PRIORITY">4</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <PhysConn type="Plug">
          <P type="Type">10BaseT</P>
          <P type="Plug">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E06BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.10</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Measurement">
          <Private source="1704789725821" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Measurement">
          <Private source="1704789725821" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Measurement">
          <Private source="1704789725821" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
      <ConnectedAP apName="AP1" iedName="E03BPU">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.0.254</P>
          <P xsi:type="tP_OSI-AP-Title" type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">192.168.2.1</P>
          <P xsi:type="tP_OSI-AE-Qualifier" type="OSI-AE-Qualifier">23</P>
          <P xsi:type="tP_OSI-PSEL" type="OSI-PSEL">00000001</P>
          <P xsi:type="tP_OSI-SSEL" type="OSI-SSEL">0001</P>
          <P xsi:type="tP_OSI-TSEL" type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725820" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
      </ConnectedAP>
    </SubNetwork>
    <SubNetwork name="ProcessBus" type="8-MMS">
      <ConnectedAP apName="F" iedName="E01BCU">
        <Address>
          <P type="IP">10.10.0.2</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E01BPU">
        <Address>
          <P type="IP">10.10.0.3</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E02BPU">
        <Address>
          <P type="IP">10.10.0.4</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E02BUP">
        <Address>
          <P type="IP">10.10.0.5</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E01BUP">
        <Address>
          <P type="IP">10.10.0.6</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E03BCU">
        <Address>
          <P type="IP">10.10.0.7</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E03BUP">
        <Address>
          <P type="IP">10.10.0.9</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E05BPU">
        <Address>
          <P type="IP">10.10.0.12</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E05BUP">
        <Address>
          <P type="IP">10.10.0.13</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E04BPU">
        <Address>
          <P type="IP">10.10.0.18</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E04BUP">
        <Address>
          <P type="IP">10.10.0.19</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="F" iedName="E06BCU">
        <Address>
          <P type="IP">10.10.0.20</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E06BPU">
        <Address>
          <P type="IP">10.10.0.21</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E06BUP">
        <Address>
          <P type="IP">10.10.0.22</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E01PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">00000001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725813" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="LD0">
          <Private source="1704789725814" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="LD0">
          <Private source="1704789725814" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="LD0">
          <Private source="1704789725913" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="S2" iedName="E02BCU">
        <Address>
          <P type="IP">127.0.0.1</P>
          <P type="OSI-AP-Title">1,3,9999,1</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">127.0.0.0</P>
          <P type="OSI-AE-Qualifier">12</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E02PIU" redProt="prp">
        <Address>
          <P xsi:type="tP_IP" type="IP">192.168.100.103</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">192.168.100.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Trip">
          <Private source="1704789725819" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Trip">
          <Private source="1704789725819" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Trip">
          <Private source="1704789725819" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="Trip">
          <Private source="1704789725918" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E03PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.17</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725818" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="LD0">
          <Private source="1704789725818" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="LD0">
          <Private source="1704789725818" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="LD0">
          <Private source="1704789725917" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">Connection Port TS1-X103 Type RJ45RedConn Port TS1-X104 Type RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E04PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.16</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725801" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="LD0">
          <Private source="1704789725802" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="LD0">
          <Private source="1704789725802" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="LD0">
          <Private source="1704789725910" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">Connection Port TS1-X103 Type RJ45RedConn Port TS1-X104 Type RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E04BCU">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.10.0.10</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="E" iedName="E05PIU" redProt="prp">
        <Address>
          <P xsi:type="tP_IP" type="IP">10.10.0.14</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P xsi:type="tP_IP-SUBNET" type="IP-SUBNET">255.255.255.0</P>
          <P xsi:type="tP_IP-GATEWAY" type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="Trip">
          <Private source="1704789725817" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="Trip">
          <Private source="1704789725817" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="Trip">
          <Private source="1704789725817" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="Trip">
          <Private source="1704789725916" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
      </ConnectedAP>
      <ConnectedAP apName="S2" iedName="E05BCU">
        <Address>
          <P type="IP">10.10.0.11</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
      <ConnectedAP apName="S1" iedName="E06PIU" redProt="hsr">
        <Address>
          <P type="IP">10.10.0.15</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
        <GSE cbName="gcb_f1" ldInst="LD0">
          <Private source="1704789725809" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">5</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l1" ldInst="LD0">
          <Private source="1704789725809" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <GSE cbName="gcb_l2" ldInst="LD0">
          <Private source="1704789725809" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-01-00-00</P>
            <P type="APPID">0000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
          <MinTime multiplier="m" unit="s">500</MinTime>
          <MaxTime multiplier="m" unit="s">10000</MaxTime>
        </GSE>
        <SMV cbName="smvcba" ldInst="LD0">
          <Private source="1704789725909" type="HELINKS_TAG"/>
          <Address>
            <P type="MAC-Address">01-0C-CD-04-01-FF</P>
            <P type="APPID">4000</P>
            <P type="VLAN-PRIORITY">4</P>
            <P type="VLAN-ID">000</P>
          </Address>
        </SMV>
        <PhysConn type="Connection">
          <P type="Port">TS1-X103</P>
          <P type="Type">Connection Port TS1-X103 Type RJ45RedConn Port TS1-X104 Type RJ45</P>
        </PhysConn>
        <PhysConn type="RedConn">
          <P type="Port">TS1-X104</P>
          <P type="Type">RJ45</P>
        </PhysConn>
      </ConnectedAP>
      <ConnectedAP apName="AP2" iedName="E03BPU">
        <Address>
          <P type="IP">10.10.0.8</P>
          <P type="OSI-AP-Title">1,3,9999,23</P>
          <P type="IP-SUBNET">255.255.255.0</P>
          <P type="IP-GATEWAY">10.10.0.1</P>
          <P type="OSI-AE-Qualifier">23</P>
          <P type="OSI-PSEL">00000001</P>
          <P type="OSI-SSEL">0001</P>
          <P type="OSI-TSEL">0001</P>
        </Address>
      </ConnectedAP>
    </SubNetwork>
  </Communication>
  <IED configVersion="1" manufacturer="no manufacturer" type="gateway" name="XPG">
    <Services nameLength="64">
      <DynAssociation max="10"/>
      <SettingGroups>
        <SGEdit resvTms="false"/>
        <ConfSG resvTms="false"/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <SetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="32" maxAttributes="100" modify="true"/>
      <DynDataSet max="32" maxAttributes="100"/>
      <ReadWrite/>
      <ConfReportControl max="16" bufConf="true" bufMode="both"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Conf" bufTime="Conf" intgPd="Conf" optFields="Conf" owner="true" resvTms="true" rptID="Conf" trgOps="Conf"/>
      <LogSettings cbName="Conf" datSet="Conf" intgPd="Conf" logEna="Conf" trgOps="Conf"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf"/>
      <GSEDir/>
      <GOOSE max="8" fixedOffs="false"/>
      <SMVsc max="12" delivery="both" deliveryConf="true"/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="true" goose="true" gsse="false" maxAttributes="250" maxGOOSE="32" maxReports="32" maxSMV="32" readLog="false" supportsLdName="true" sv="true" unbufReport="true">
        <TimeSyncProt sntp="true" c37_238="false" other="false"/>
      </ClientServices>
      <ConfLdName/>
    </Services>
    <AccessPoint clock="false" router="false" name="AP1">
      <Server>
        <Authentication none="true"/>
        <LDevice inst="LD0">
          <LN lnType="lphd_7_4_B2007" inst="1" lnClass="LPHD"/>
          <LN lnType="itci_7_4_B2007" inst="1" lnClass="ITCI">
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mir.desc" name="Mir">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcExp.desc" name="ClcExp">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcStr.desc" name="ClcStr">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMth.desc" name="ClcMth">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMod.desc" name="ClcMod">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvTyp.desc" name="ClcIntvTyp">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvPer.desc" name="ClcIntvPer">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.NumSubIntv.desc" name="NumSubIntv">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfTyp.desc" name="ClcRfTyp">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfPer.desc" name="ClcRfPer">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcSrc.desc" name="ClcSrc">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcNxtTmms.desc" name="ClcNxtTmms">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="minVal" valKind="Set"/>
              <DAI name="maxVal" valKind="Set"/>
              <DAI name="stepSize" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.InSyn.desc" name="InSyn">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEName.desc" name="EEName">
              <DAI name="vendor" valKind="Set"/>
              <DAI name="hwRev" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="serNum" valKind="Set"/>
              <DAI name="model" valKind="Set"/>
              <DAI name="location" valKind="Set"/>
              <DAI name="name" valKind="Set"/>
              <DAI name="owner" valKind="Set"/>
              <DAI name="ePSName" valKind="Set"/>
              <DAI name="primeOper" valKind="Set"/>
              <DAI name="secondOper" valKind="Set"/>
              <DAI name="latitude" valKind="Set"/>
              <DAI name="longitude" valKind="Set"/>
              <DAI name="altitude" valKind="Set"/>
              <DAI name="mRID" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEHealth.desc" name="EEHealth">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.OpTmh.desc" name="OpTmh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="units">
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
              </SDI>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupI::ITCI.Alm.desc" name="Alm">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <Inputs>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E02BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E03BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E04BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E05BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E05BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcbb" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Start" doName="Str" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E06BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="Report" srcCBName="brcbA" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB02" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="1" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BPU" ldInst="Differential" lnClass="TCTR" lnInst="4" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Differential" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcbb" srcLDInst="Measurement" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="AP1">
      <LN lnType="itci_7_4_B2007" inst="1" lnClass="ITCI">
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.NamPlt.desc" name="NamPlt">
          <DAI name="paramRev" valKind="Set"/>
          <DAI name="valRev" valKind="Set"/>
          <DAI name="vendor" valKind="Set"/>
          <DAI name="swRev" valKind="Set"/>
          <DAI name="ldNs" valKind="Set"/>
          <DAI name="lnNs" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="configRev" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Beh.desc" name="Beh">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Health.desc" name="Health">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mir.desc" name="Mir">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.Mod.desc" name="Mod">
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="ctlModel" valKind="Set"/>
          <DAI name="ctlNum" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="operTimeout" valKind="Set"/>
          <DAI name="opOk" valKind="Set"/>
          <DAI name="opRcvd" valKind="Set"/>
          <SDI name="origin">
            <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
            <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
          </SDI>
          <DAI name="q" valKind="Set"/>
          <DAI name="sboClass" valKind="Set"/>
          <DAI name="sboTimeout" valKind="Set"/>
          <DAI name="stSeld" valKind="Set"/>
          <DAI name="stVal" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="tOpOk" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::DomainLN.InRef.desc" name="InRef">
          <DAI name="setSrcRef" valKind="Set"/>
          <DAI name="setTstRef" valKind="Set"/>
          <DAI name="setSrcCB" valKind="Set"/>
          <DAI name="setTstCB" valKind="Set"/>
          <DAI name="intAddr" valKind="Set"/>
          <DAI name="tstEna" valKind="Set"/>
          <DAI name="purpose" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcExp.desc" name="ClcExp">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcStr.desc" name="ClcStr">
          <SDI name="origin">
            <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
            <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
          </SDI>
          <DAI name="ctlNum" valKind="Set"/>
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="stSeld" valKind="Set"/>
          <DAI name="opRcvd" valKind="Set"/>
          <DAI name="opOk" valKind="Set"/>
          <DAI name="tOpOk" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <SDI name="pulseConfig">
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
          </SDI>
          <DAI name="ctlModel" valKind="Set"/>
          <DAI name="sboTimeout" valKind="Set"/>
          <DAI name="sboClass" valKind="Set"/>
          <DAI name="operTimeout" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMth.desc" name="ClcMth">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcMod.desc" name="ClcMod">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvTyp.desc" name="ClcIntvTyp">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcIntvPer.desc" name="ClcIntvPer">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="minVal" valKind="Set"/>
          <DAI name="maxVal" valKind="Set"/>
          <DAI name="stepSize" valKind="Set"/>
          <SDI name="units">
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
          </SDI>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.NumSubIntv.desc" name="NumSubIntv">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="minVal" valKind="Set"/>
          <DAI name="maxVal" valKind="Set"/>
          <DAI name="stepSize" valKind="Set"/>
          <SDI name="units">
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
          </SDI>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfTyp.desc" name="ClcRfTyp">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcRfPer.desc" name="ClcRfPer">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="minVal" valKind="Set"/>
          <DAI name="maxVal" valKind="Set"/>
          <DAI name="stepSize" valKind="Set"/>
          <SDI name="units">
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
          </SDI>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcSrc.desc" name="ClcSrc">
          <DAI name="setSrcRef" valKind="Set"/>
          <DAI name="setTstRef" valKind="Set"/>
          <DAI name="setSrcCB" valKind="Set"/>
          <DAI name="setTstCB" valKind="Set"/>
          <DAI name="intAddr" valKind="Set"/>
          <DAI name="tstEna" valKind="Set"/>
          <DAI name="purpose" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.ClcNxtTmms.desc" name="ClcNxtTmms">
          <DAI name="setVal" valKind="Set"/>
          <DAI name="minVal" valKind="Set"/>
          <DAI name="maxVal" valKind="Set"/>
          <DAI name="stepSize" valKind="Set"/>
          <SDI name="units">
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
          </SDI>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::StatisticsLN.InSyn.desc" name="InSyn">
          <DAI name="setSrcRef" valKind="Set"/>
          <DAI name="setTstRef" valKind="Set"/>
          <DAI name="setSrcCB" valKind="Set"/>
          <DAI name="setTstCB" valKind="Set"/>
          <DAI name="intAddr" valKind="Set"/>
          <DAI name="tstEna" valKind="Set"/>
          <DAI name="purpose" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEName.desc" name="EEName">
          <DAI name="vendor" valKind="Set"/>
          <DAI name="hwRev" valKind="Set"/>
          <DAI name="swRev" valKind="Set"/>
          <DAI name="serNum" valKind="Set"/>
          <DAI name="model" valKind="Set"/>
          <DAI name="location" valKind="Set"/>
          <DAI name="name" valKind="Set"/>
          <DAI name="owner" valKind="Set"/>
          <DAI name="ePSName" valKind="Set"/>
          <DAI name="primeOper" valKind="Set"/>
          <DAI name="secondOper" valKind="Set"/>
          <DAI name="latitude" valKind="Set"/>
          <DAI name="longitude" valKind="Set"/>
          <DAI name="altitude" valKind="Set"/>
          <DAI name="mRID" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.EEHealth.desc" name="EEHealth">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessInterfaceLN.OpTmh.desc" name="OpTmh">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <SDI name="units">
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.SIUnit.desc" name="SIUnit" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::Unit.multiplier.desc" name="multiplier" valKind="Set"/>
          </SDI>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.Loc.desc" name="Loc">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocKey.desc" name="LocKey">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.AbstractLNsCommon::NonProcessControllingEquipmentInterfaceLN.LocSta.desc" name="LocSta">
          <SDI name="origin">
            <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
            <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
          </SDI>
          <DAI name="ctlNum" valKind="Set"/>
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="stSeld" valKind="Set"/>
          <DAI name="opRcvd" valKind="Set"/>
          <DAI name="opOk" valKind="Set"/>
          <DAI name="tOpOk" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <SDI name="pulseConfig">
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
            <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
          </SDI>
          <DAI name="ctlModel" valKind="Set"/>
          <DAI name="sboTimeout" valKind="Set"/>
          <DAI name="sboClass" valKind="Set"/>
          <DAI name="operTimeout" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
        <DOI desc="IEC61850_7_4.LNGroupI::ITCI.Alm.desc" name="Alm">
          <DAI name="stVal" valKind="Set"/>
          <DAI name="q" valKind="Set"/>
          <DAI name="t" valKind="Set"/>
          <DAI name="subEna" valKind="Set"/>
          <DAI name="subVal" valKind="Set"/>
          <DAI name="subQ" valKind="Set"/>
          <DAI name="subID" valKind="Set"/>
          <DAI name="blkEna" valKind="Set"/>
          <DAI name="d" valKind="Set"/>
          <DAI name="dU" valKind="Set"/>
          <DAI name="cdcName" valKind="Set"/>
          <DAI name="dataNs" valKind="Set"/>
        </DOI>
      </LN>
    </AccessPoint>
  </IED>
  <IED desc="ZENON HMI" configVersion="2.1" manufacturer="Copa-Data" originalSclRevision="B" originalSclVersion="2007" owner="" type="ZENON" name="Zenon">
    <AccessPoint clock="true" name="S1">
      <LN lnType="ITCI_ZENON" inst="1" lnClass="ITCI">
        <Inputs>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E02BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E02BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E02BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E03BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E03BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E03BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E03BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E04BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E04BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E04BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E04BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Diff Operate" doName="Op" iedName="E05BPU" ldInst="Differential" lnClass="PDIF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Differential" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E05BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E05BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="BRCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z1" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z1" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="1" prefix="Z1" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z2" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z2" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="2" prefix="Z2" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Start Z3" doName="Str" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Z3" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PDIS" lnInst="3" prefix="Z3" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E06BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="Report" srcCBName="brcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="BF Start" doName="Str" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E06BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QB1 Position" doName="Pos" iedName="E06BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="stVal" desc="QA0 Position" doName="Pos" iedName="E06BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="Report" srcCBName="brcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E01BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E01BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E02BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E02BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E03BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E03BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E03BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E04BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E04BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E04BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E05BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="URCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E05BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="Overcurrent" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I1" doName="A.phsA" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I2" doName="A.phsB" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I3" doName="A.phsC" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="I Neut" doName="A.neut" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U1" doName="PhV.phsA" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U2" doName="PhV.phsB" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U3" doName="PhV.phsC" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="cVal.mag.f" desc="U Neut" doName="PhV.net" iedName="E06BCU" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V" serviceType="Report" srcCBName="urcba" srcLDInst="Measurement" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E06BPU" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E06BPU" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N" serviceType="Report" srcCBName="urcba" srcLDInst="LD0" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
          <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E06BUP" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N" serviceType="Report" srcCBName="urcbA" srcLDInst="System" srcLNClass="LLN0"/>
        </Inputs>
      </LN>
      <Services nameLength="64">
        <ClientServices bufReport="true" maxAttributes="50000" maxReports="200" supportsLdName="true" unbufReport="true">
          <TimeSyncProt sntp="true"/>
        </ClientServices>
        <TimeSyncProt sntp="true"/>
      </Services>
    </AccessPoint>
    <AccessPoint clock="true" name="S2">
      <LN lnType="ITCI_ZENON" inst="2" lnClass="ITCI"/>
      <Services nameLength="64">
        <ClientServices bufReport="true" maxAttributes="50000" maxReports="200" supportsLdName="true" unbufReport="true">
          <TimeSyncProt sntp="true"/>
        </ClientServices>
        <TimeSyncProt sntp="true"/>
      </Services>
    </AccessPoint>
  </IED>
  <IED desc="SAM600-MU" configVersion="1.0" manufacturer="ABB" originalSclRevision="B" originalSclVersion="2007" type="SAM600" name="E01PIU">
    <Private type="ABB_PCMObjectTypeName">SAM600</Private>
    <Private type="ABBPCMInternalObjRef">5daad46d-3102-4342-bc72-72a3ee953258</Private>
    <Private type="ABB SAM600 Stream Mapping">
      <eSAM:ArrayOfStreamMapping xmlns:eSAM="http://www.abb.com/61850/2016/SAM600Mapping">
        <eSAM:StreamMapping>
          <eSAM:StreamId>Stream01</eSAM:StreamId>
          <eSAM:MappedLds>
            <eSAM:string>MU01</eSAM:string>
          </eSAM:MappedLds>
          <eSAM:SelectedCt>CT1</eSAM:SelectedCt>
          <eSAM:SelectedVt>VT1</eSAM:SelectedVt>
        </eSAM:StreamMapping>
      </eSAM:ArrayOfStreamMapping>
    </Private>
    <Private type="ABB Comm">
      <eComm:CommNode x="-536870912" y="-536870912">
        <eComm:MergingUnit/>
        <eComm:Port id="TS1-X103" xRel="0" yRel="0"/>
        <eComm:Port id="TS1-X104" xRel="0" yRel="0"/>
      </eComm:CommNode>
    </Private>
    <Services nameLength="64">
      <DynAssociation max="6"/>
      <SettingGroups>
        <SGEdit resvTms="true"/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="50" maxAttributes="100" modify="true"/>
      <DynDataSet max="30" maxAttributes="60"/>
      <ReadWrite/>
      <ConfReportControl max="60" bufConf="true" bufMode="both"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" resvTms="true" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
      <SMVSettings cbName="Conf" datSet="Conf"/>
      <GOOSE max="16" fixedOffs="false"/>
      <SMVsc max="10"/>
      <FileHandling/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="false" goose="true" gsse="false" maxAttributes="1000" maxGOOSE="128" readLog="false" supportsLdName="true" sv="false" unbufReport="false">
        <TimeSyncProt/>
      </ClientServices>
      <ConfLdName/>
      <SupSubscription maxGo="128" maxSv="0"/>
      <ValueHandling setToRO="false"/>
      <RedProt hsr="true" prp="true" rstp="true"/>
      <CommProt ipv6="false"/>
    </Services>
    <AccessPoint name="SAM600ServerModel">
      <Server>
        <Authentication/>
        <LDevice inst="LD0" ldName="CardiffETransformerTrip">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DataSet name="ds_gcb_f1">
              <Private source="1704789725813" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="Tr" fc="ST" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="Trip"/>
              <FCDA daName="q" doName="Tr" fc="ST" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="Trip"/>
            </DataSet>
            <DataSet name="ds_gcb_l1">
              <Private source="1704789725814" type="HELINKS_TAG"/>
              <FCDA daName="stVal" doName="Pos" fc="ST" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0"/>
              <FCDA daName="q" doName="Pos" fc="ST" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0"/>
            </DataSet>
            <DataSet name="ds_gcb_l2">
              <Private source="1704789725814" type="HELINKS_TAG"/>
              <FCDA daName="stVal" doName="Pos" fc="ST" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" prefix="QB1"/>
              <FCDA daName="q" doName="Pos" fc="ST" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" prefix="QB1"/>
            </DataSet>
            <DataSet name="ds_smvcba">
              <Private source="1704789725913" type="HELINKS_TAG"/>
              <FCDA daName="instMag.i" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="1" prefix="A"/>
              <FCDA daName="instMag.f" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="2" prefix="B"/>
              <FCDA daName="instMag.i" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="3" prefix="C"/>
              <FCDA daName="instMag.i" doName="AmpSv" fc="MX" ldInst="CTCT" lnClass="TCTR" lnInst="4" prefix="N"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="1" prefix="A"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="2" prefix="B"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="3" prefix="C"/>
              <FCDA daName="instMag.i" doName="VolSv" fc="MX" ldInst="VTVT" lnClass="TVTR" lnInst="4" prefix="N"/>
            </DataSet>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <Inputs>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="gcb_l2" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="gcb_l2" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="gcb_l2" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1" serviceType="GOOSE" srcCBName="gcb_l2" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="GOOSE" srcCBName="gcb_l1" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate Open" doName="OpOpn" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="GOOSE" srcCBName="gcb_l1" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="GOOSE" srcCBName="gcb_l1" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate Close" doName="OpCls" iedName="E01BCU" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0" serviceType="GOOSE" srcCBName="gcb_l1" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate Internal" doName="OpIn" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate Internal" doName="OpIn" iedName="E01BCU" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="DIS Operate" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="DIS Operate" doName="Op" iedName="E01BPU" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="DIS" serviceType="GOOSE" srcCBName="gcb_f1" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="OC Operate" doName="Op" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="GOOSE" srcCBName="gcb01" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="OC Operate" doName="Op" iedName="E01BUP" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH" serviceType="GOOSE" srcCBName="gcb01" srcLDInst="System" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate External" doName="OpEx" iedName="E02BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="general" desc="Operate External" doName="OpEx" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="Operate External" doName="OpEx" iedName="E05BCU" ldInst="BreakerFailure" lnClass="RBRF" lnInst="1" prefix="" serviceType="GOOSE" srcCBName="GoCB01" srcLDInst="Measurement" srcLNClass="LLN0"/>
            </Inputs>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_f1" name="gcb_f1" confRev="10000" appID="E01PIULD0/LLN0gcb_f1" securityEnable="None">
              <Private source="1704789725813" type="HELINKS_TAG"/>
              <IEDName apRef="E" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix="">E01BCU</IEDName>
            </GSEControl>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_l1" name="gcb_l1" confRev="10000" appID="E01PIULD0/LLN0gcb_l1" securityEnable="None">
              <Private source="1704789725813" type="HELINKS_TAG"/>
              <IEDName apRef="E" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0">E01BCU</IEDName>
            </GSEControl>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_l2" name="gcb_l2" confRev="10000" appID="E01PIULD0/LLN0gcb_l2" securityEnable="None">
              <Private source="1704789725814" type="HELINKS_TAG"/>
              <IEDName apRef="E" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1">E01BCU</IEDName>
            </GSEControl>
            <SampledValueControl desc="Helinks default SMV Control Block" datSet="ds_smvcba" name="smvcba" confRev="10000" multicast="true" nofASDU="1" securityEnable="None" smpRate="80" smvID="E01PIULD0/LLN0smvcba">
              <Private source="1704789725912" type="HELINKS_TAG"/>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TCTR" lnInst="2" prefix="A">E01BPU</IEDName>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TCTR" lnInst="3" prefix="B">E01BPU</IEDName>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TCTR" lnInst="7" prefix="C">E01BPU</IEDName>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TCTR" lnInst="8" prefix="N">E01BPU</IEDName>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TVTR" lnInst="7" prefix="A">E01BPU</IEDName>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TVTR" lnInst="8" prefix="B">E01BPU</IEDName>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TVTR" lnInst="4" prefix="C">E01BPU</IEDName>
              <IEDName apRef="AP1" ldInst="LD0" lnClass="TVTR" lnInst="1" prefix="N">E01BPU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TCTR" lnInst="5" prefix="A">E01BCU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TCTR" lnInst="1" prefix="B">E01BCU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TCTR" lnInst="4" prefix="C">E01BCU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TCTR" lnInst="6" prefix="N">E01BCU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TVTR" lnInst="2" prefix="A">E01BCU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TVTR" lnInst="12" prefix="B">E01BCU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TVTR" lnInst="14" prefix="C">E01BCU</IEDName>
              <IEDName apRef="E" ldInst="Measurement" lnClass="TVTR" lnInst="3" prefix="N">E01BCU</IEDName>
              <IEDName apRef="AP1" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A">E01BUP</IEDName>
              <IEDName apRef="AP1" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B">E01BUP</IEDName>
              <IEDName apRef="AP1" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C">E01BUP</IEDName>
              <IEDName apRef="AP1" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N">E01BUP</IEDName>
              <SmvOpts refreshTime="false" sampleRate="false" sampleSynchronized="true" security="false"/>
            </SampledValueControl>
          </LN0>
          <LN lnType="ptrc_7_4_B2007" inst="1" lnClass="PTRC" prefix="Trip">
            <DOI desc="IEC61850_7_4.LNGroupP::PTRC.Tr.desc" name="Tr">
              <DAI name="general" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QB1Interface" ldName="CardiffETransformerQB1Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xswi_7_4_B2007" inst="1" lnClass="XSWI" prefix="QB1">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="QA0Interface" ldName="CardiffETransformerQA0Interface">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="xcbr_7_4_B2007" inst="1" lnClass="XCBR" prefix="QA0">
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.AbstractLNsGroupX::SwitchingEquipmentLN.Pos.desc" name="Pos">
              <DAI name="stVal" valKind="Set"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="CTCT" ldName="CardiffETransformerCTCT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="2" lnClass="TCTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="3" lnClass="TCTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice inst="VTVT" ldName="CardiffETransformerVTVT">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="tvtr_7_4_B2007" inst="1" lnClass="TVTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="2" lnClass="TVTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="3" lnClass="TVTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="4" lnClass="TVTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="S1">
      <ServerAt apName="SAM600ServerModel"/>
      <Services nameLength="64">
        <DynAssociation max="6"/>
        <SettingGroups>
          <SGEdit resvTms="true"/>
        </SettingGroups>
        <GetDirectory/>
        <GetDataObjectDefinition/>
        <DataObjectDirectory/>
        <GetDataSetValue/>
        <DataSetDirectory/>
        <ConfDataSet max="50" maxAttributes="100" modify="true"/>
        <DynDataSet max="30" maxAttributes="60"/>
        <ReadWrite/>
        <ConfReportControl max="60" bufConf="true" bufMode="both"/>
        <GetCBValues/>
        <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" resvTms="true" rptID="Dyn" trgOps="Dyn"/>
        <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
        <SMVSettings cbName="Conf" datSet="Conf"/>
        <GOOSE max="16" fixedOffs="false"/>
        <SMVsc max="10"/>
        <FileHandling/>
        <ConfLNs fixLnInst="false" fixPrefix="false"/>
        <ClientServices bufReport="false" goose="true" gsse="false" maxGOOSE="128" readLog="false" supportsLdName="true" sv="false" unbufReport="false">
          <TimeSyncProt/>
        </ClientServices>
        <ConfLdName/>
        <SupSubscription maxGo="128" maxSv="0"/>
        <ValueHandling setToRO="false"/>
        <RedProt hsr="true" prp="true" rstp="true"/>
        <CommProt ipv6="false"/>
      </Services>
    </AccessPoint>
  </IED>
  <IED desc="BEV2-P545" configVersion="P545v71I" manufacturer="ALSTOM" originalSclRevision="B" originalSclVersion="2007" type="P545" name="E01BUP">
    <Private type="MiCOM-ModellingToolID">ALSTOM IEC61850 Px40 Modelling Tool</Private>
    <Private type="MiCOM-ModellingToolVersion">2.34</Private>
    <Private type="MiCOM-ModelNumber">P545???????710* (I)</Private>
    <Private type="MiCOM-SNTPServers">2</Private>
    <Private type="MiCOM-TimeServer"/>
    <Private type="MiCOM-MCLVersion">V2.0</Private>
    <Private type="MiCOM-UniqueID">33727749-529753443.9-6509</Private>
    <Services>
      <DynAssociation/>
      <SettingGroups/>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="100" modify="true"/>
      <ReadWrite/>
      <ConfReportControl max="24"/>
      <GetCBValues/>
      <ReportSettings cbName="Fix" datSet="Conf" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Fix" datSet="Conf" appID="Conf"/>
      <GOOSE max="8"/>
      <FileHandling/>
      <ConfLNs fixLnInst="true" fixPrefix="true"/>
      <ClientServices sv="true"/>
    </Services>
    <AccessPoint desc="IEC61850 Interface" clock="false" router="false" name="AP1">
      <Server desc="IEC61850 Compliant data model" timeout="900">
        <Authentication none="true"/>
        <LDevice inst="Overcurrent">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
          </LN0>
          <LN lnType="ptoc_7_4_B2007" inst="1" lnClass="PTOC" prefix="PH"/>
          <LN lnType="ptrc_7_4_B2007" inst="1" lnClass="PTRC" prefix="OC"/>
          <LN lnType="tctr_7_4_B2007" inst="5" lnClass="TCTR" prefix="A"/>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="B"/>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="C"/>
          <LN lnType="tctr_7_4_B2007" inst="6" lnClass="TCTR" prefix="N"/>
        </LDevice>
        <LDevice desc="Controls Domain" inst="Control">
          <LN0 desc="Controls Logical Device" lnType="LLN0_CONTROL$_0669a0bf-605c-44e1-aa70-e1a4ba7df2ce" inst="" lnClass="LLN0">
            <Private type="MiCOM-ConfigurableAttributes">AscMod.ctlModel,ArcMod.ctlModel,PsbMod.ctlModel,</Private>
            <DOI name="ArcBeh">
              <DAI desc="[09 24] - Auto-Reclose" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 24] - Auto-Reclose" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ArcMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 24] - Auto-Reclose" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 24] - Auto-Reclose" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="AscBeh">
              <DAI desc="[09 23] - System Checks" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 23] - System Checks" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="AscMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 23] - System Checks" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 23] - System Checks" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Controls Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PsbBeh">
              <DAI desc="[09 18] - PowerSwing Block" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 18] - PowerSwing Block" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PsbMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 18] - PowerSwing Block" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 18] - PowerSwing Block" name="stVal" valKind="RO"/>
            </DOI>
          </LN0>
          <LN desc="Auto Reclose" lnType="RREC_NO_SEG" inst="1" lnClass="RREC" prefix="Arc">
            <DOI name="AutoRecSt">
              <DAI desc="Reads the Autoreclose (CB1) Status with respect to the 'AutoRecSt' Attribute in the RREC Logical Node." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 64] - ArcRREC1.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 24] - Auto-Reclose" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[09 24] - Auto-Reclose" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 854" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="System Checks - Check Sync 1" lnType="RSYN_DIFCLC_ENH" inst="1" lnClass="RSYN" prefix="Asc">
            <Private type="MiCOM-ConfigurableAttributes">DifHzClc.units.multiplier,DifHzClc.db,DifHzClc.rangeC.min.f,DifHzClc.rangeC.max.f,DifAngClc.units.multiplier,DifAngClc.db,DifAngClc.rangeC.min.f,DifAngClc.rangeC.max.f,</Private>
            <DOI name="AngInd">
              <DAI desc="Returns Status of Angle Difference Indicator for Circuit Breaker 1 Check Sync Threshold 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 05] - AscRSYN1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAngClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>360</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="DifHzClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 31] - Slip Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 31] - Slip Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="HzInd">
              <DAI desc="Returns Status of Frequency Difference Indicator for Circuit Breaker 1 Check Sync Threshold 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[48 8F] - CS1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[48 8F] - CS1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Rel">
              <DAI desc="DDB Ordinal: 883" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VInd">
              <DAI desc="Returns Status of Voltage Difference Indicator for Circuit Breaker 1 Check Sync Threshold 1" name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="System Checks - Check Sync 2" lnType="RSYN_DIFCLC_ENH" inst="2" lnClass="RSYN" prefix="Asc">
            <Private type="MiCOM-ConfigurableAttributes">DifHzClc.units.multiplier,DifHzClc.db,DifHzClc.rangeC.min.f,DifHzClc.rangeC.max.f,DifAngClc.units.multiplier,DifAngClc.db,DifAngClc.rangeC.min.f,DifAngClc.rangeC.max.f,</Private>
            <DOI name="AngInd">
              <DAI desc="Returns Status of Angle Difference Indicator for Circuit Breaker 1 Check Sync Threshold 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 06] - AscRSYN2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAngClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>360</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 30] - C/S Bus-Line Ang" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="DifHzClc">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 31] - Slip Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 31] - Slip Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="HzInd">
              <DAI desc="Returns Status of Frequency Difference Indicator for Circuit Breaker 1 Check Sync Threshold 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[48 94] - CS2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[48 94] - CS2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Rel">
              <DAI desc="DDB Ordinal: 884" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VInd">
              <DAI desc="Returns Status of Voltage Difference Indicator for Circuit Breaker 1 Check Sync Threshold 2" name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Interlocking (Pole 1)" lnType="CILO_INTERLOCK" inst="1" lnClass="CILO">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaCls">
              <DAI desc="DDB Ordinal: 1717" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaOpn">
              <DAI desc="DDB Ordinal: 1718" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>direct-with-normal-security</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>CB (1) Condition (Pole 1)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Interlocking (Pole 2)" lnType="CILO_INTERLOCK" inst="2" lnClass="CILO">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaCls">
              <DAI desc="DDB Ordinal: 1717" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaOpn">
              <DAI desc="DDB Ordinal: 1718" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>direct-with-normal-security</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>CB (1) Condition (Pole 2)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Interlocking (Pole 3)" lnType="CILO_INTERLOCK" inst="3" lnClass="CILO">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaCls">
              <DAI desc="DDB Ordinal: 1717" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EnaOpn">
              <DAI desc="DDB Ordinal: 1718" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>direct-with-normal-security</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>CB (1) Condition (Pole 3)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Out of Step Tripping (main trip)" lnType="RPSB_OST" inst="1" lnClass="RPSB" prefix="Ost">
            <DOI name="Beh">
              <DAI desc="[FE 35] - OstRPSB1.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 23] - OST Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Out of Step tripping (Main)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 553" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Out of Step Tripping (predictive trip)" lnType="RPSB_OST" inst="2" lnClass="RPSB" prefix="Ost">
            <DOI name="Beh">
              <DAI desc="[FE 36] - OstRPSB2.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 23] - OST Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Out of Step tripping (Predictive)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 551" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 1 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="1" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1349" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 1 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 2 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="2" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1350" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 2 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 3 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="3" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1351" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 3 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 4 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="4" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1353" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 4 Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 5 Ph/Gnd Power Swing Blocking" lnType="RPSB_PSB_MULTI" inst="5" lnClass="RPSB" prefix="Psb">
            <DOI name="Beh">
              <DAI desc="[FE 38] - PsbRPSBx.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkZn">
              <DAI desc="DDB Ordinal: 1352" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3D 40] - Slow Swing" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone P Ph/Gnd Power Swing Blocking Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 297" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 607" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 607" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Monitoring (Pole 1)" lnType="XCBR_BASIC$_7ed30635-2b13-4154-b523-acd4e7f6f2c4" inst="1" lnClass="XCBR">
            <Private type="MiCOM-ConfigurableAttributes">Lock.ctlModel,Lock.sboTimeout,Pos.ctlModel,Pos.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkCls">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="BlkOpn">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="CBOpCap">
              <DAI desc="Returns circuit breaker 1 Pole &quot;A&quot; operating capability." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EEHealth">
              <DAI desc="Returns the Health of the CB with respect to XCBR.EEHealth." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Loc">
              <DAI desc="[07 01] - CB Control by" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Lock">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Pole 1 Circuit Breaker (Phase A)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpCnt">
              <DAI desc="[06 02] - CB A Operations" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Pos">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="Returns the Status of A-Phase CB with respect to XCBR.Pos." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Monitoring (Pole 2)" lnType="XCBR_BASIC$_7ed30635-2b13-4154-b523-acd4e7f6f2c4" inst="2" lnClass="XCBR">
            <Private type="MiCOM-ConfigurableAttributes">Lock.ctlModel,Lock.sboTimeout,Pos.ctlModel,Pos.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkCls">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="BlkOpn">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="CBOpCap">
              <DAI desc="Returns circuit breaker 1 Pole &quot;B&quot; operating capability" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EEHealth">
              <DAI desc="Returns the Health of the CB with respect to XCBR.EEHealth." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Loc">
              <DAI desc="[07 01] - CB Control by" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Lock">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Pole 2 Circuit Breaker (Phase B)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpCnt">
              <DAI desc="[06 03] - CB B Operations" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Pos">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="Returns the Status of B-Phase CB with respect to XCBR.Pos." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker Monitoring (Pole 3)" lnType="XCBR_BASIC$_7ed30635-2b13-4154-b523-acd4e7f6f2c4" inst="3" lnClass="XCBR">
            <Private type="MiCOM-ConfigurableAttributes">Lock.ctlModel,Lock.sboTimeout,Pos.ctlModel,Pos.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="BlkCls">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="BlkOpn">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="CBOpCap">
              <DAI desc="Returns circuit breaker 1 Pole &quot;C&quot; operating capability." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EEHealth">
              <DAI desc="Returns the Health of the CB with respect to XCBR.EEHealth." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Loc">
              <DAI desc="[07 01] - CB Control by" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Lock">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Pole 3 Circuit Breaker (Phase C)</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpCnt">
              <DAI desc="[06 04] - CB C Operations" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Pos">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="Returns the Status of C-Phase CB with respect to XCBR.Pos." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="Measurements Domain" inst="Measurements">
          <LN0 desc="Measurements Logical Device" lnType="LLN0_STANDARD" inst="" lnClass="LLN0">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Measurements Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN0>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Current Differential Measurements" lnType="MMXU_INDIFF" inst="1" lnClass="MMXU" prefix="PriDif">
            <Private type="MiCOM-ConfigurableAttributes">A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.phsA.units.multiplier,A2.phsA.db,A2.phsA.rangeC.min.f,A2.phsA.rangeC.max.f,A2.phsB.units.multiplier,A2.phsB.db,A2.phsB.rangeC.min.f,A2.phsB.rangeC.max.f,A2.phsC.units.multiplier,A2.phsC.db,A2.phsC.rangeC.min.f,A2.phsC.rangeC.max.f,A2.neut.units.multiplier,A2.neut.db,A2.neut.rangeC.min.f,A2.neut.rangeC.max.f,A3.phsA.units.multiplier,A3.phsA.db,A3.phsA.rangeC.min.f,A3.phsA.rangeC.max.f,A3.phsB.units.multiplier,A3.phsB.db,A3.phsB.rangeC.min.f,A3.phsB.rangeC.max.f,A3.phsC.units.multiplier,A3.phsC.db,A3.phsC.rangeC.min.f,A3.phsC.rangeC.max.f,A3.neut.units.multiplier,A3.neut.db,A3.neut.rangeC.min.f,A3.neut.rangeC.max.f,A4.phsA.units.multiplier,A4.phsA.db,A4.phsA.rangeC.min.f,A4.phsA.rangeC.max.f,A4.phsB.units.multiplier,A4.phsB.db,A4.phsB.rangeC.min.f,A4.phsB.rangeC.max.f,A4.phsC.units.multiplier,A4.phsC.db,A4.phsC.rangeC.min.f,A4.phsC.rangeC.max.f,A4.neut.units.multiplier,A4.neut.db,A4.neut.rangeC.min.f,A4.neut.rangeC.max.f,A5.phsA.units.multiplier,A5.phsA.db,A5.phsA.rangeC.min.f,A5.phsA.rangeC.max.f,A5.phsB.units.multiplier,A5.phsB.db,A5.phsB.rangeC.min.f,A5.phsB.rangeC.max.f,A5.phsC.units.multiplier,A5.phsC.db,A5.phsC.rangeC.min.f,A5.phsC.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Local Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 07] - IN local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 07] - IN local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 02] - IA Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 01] - IA local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 01] - IA local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 04] - IB Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 03] - IB local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 03] - IB local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 06] - IC Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 05] - IC local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 05] - IC local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>Remote CH1 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 0F] - IN remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0F] - IN remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0A] - IA Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 09] - IA remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 09] - IA remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0C] - IB Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0B] - IB remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0B] - IB remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0E] - IC Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0D] - IC remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0D] - IC remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Remote CH2 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 17] - IN remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 17] - IN remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 12] - IA Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 11] - IA remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 11] - IA remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 14] - IB Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 13] - IB remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 13] - IB remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 16] - IC Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 15] - IC remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 15] - IC remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A4">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1C] - IN Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1C] - IN Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 19] - IA Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 19] - IA Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1A] - IB Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1A] - IB Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1B] - IC Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1B] - IC Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A5">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Current Differential Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Fourier Measurements" lnType="MMXU_FOURIER" inst="1" lnClass="MMXU" prefix="PriFou">
            <Private type="MiCOM-ConfigurableAttributes">TotW.units.multiplier,TotW.db,TotW.rangeC.min.f,TotW.rangeC.max.f,TotVAr.units.multiplier,TotVAr.db,TotVAr.rangeC.min.f,TotVAr.rangeC.max.f,TotVA.units.multiplier,TotVA.db,TotVA.rangeC.min.f,TotVA.rangeC.max.f,TotPF.units.multiplier,TotPF.db,TotPF.rangeC.min.f,TotPF.rangeC.max.f,Hz.units.multiplier,Hz.db,Hz.rangeC.min.f,Hz.rangeC.max.f,PPV.phsAB.units.multiplier,PPV.phsAB.db,PPV.phsAB.rangeC.min.f,PPV.phsAB.rangeC.max.f,PPV.phsBC.units.multiplier,PPV.phsBC.db,PPV.phsBC.rangeC.min.f,PPV.phsBC.rangeC.max.f,PPV.phsCA.units.multiplier,PPV.phsCA.db,PPV.phsCA.rangeC.min.f,PPV.phsCA.rangeC.max.f,PhV.phsA.units.multiplier,PhV.phsA.db,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,PhV.phsB.units.multiplier,PhV.phsB.db,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.units.multiplier,PhV.phsC.db,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.res.units.multiplier,A2.res.db,A2.res.rangeC.min.f,A2.res.rangeC.max.f,A3.res.units.multiplier,A3.res.db,A3.res.rangeC.min.f,A3.res.rangeC.max.f,W.phsA.units.multiplier,W.phsA.db,W.phsA.rangeC.min.f,W.phsA.rangeC.max.f,W.phsB.units.multiplier,W.phsB.db,W.phsB.rangeC.min.f,W.phsB.rangeC.max.f,W.phsC.units.multiplier,W.phsC.db,W.phsC.rangeC.min.f,W.phsC.rangeC.max.f,VAr.phsA.units.multiplier,VAr.phsA.db,VAr.phsA.rangeC.min.f,VAr.phsA.rangeC.max.f,VAr.phsB.units.multiplier,VAr.phsB.db,VAr.phsB.rangeC.min.f,VAr.phsB.rangeC.max.f,VAr.phsC.units.multiplier,VAr.phsC.db,VAr.phsC.rangeC.min.f,VAr.phsC.rangeC.max.f,VA.phsA.units.multiplier,VA.phsA.db,VA.phsA.rangeC.min.f,VA.phsA.rangeC.max.f,VA.phsB.units.multiplier,VA.phsB.db,VA.phsB.rangeC.min.f,VA.phsB.rangeC.max.f,VA.phsC.units.multiplier,VA.phsC.db,VA.phsC.rangeC.min.f,VA.phsC.rangeC.max.f,PF.phsA.units.multiplier,PF.phsA.db,PF.phsA.rangeC.min.f,PF.phsA.rangeC.max.f,PF.phsB.units.multiplier,PF.phsB.db,PF.phsB.rangeC.min.f,PF.phsB.rangeC.max.f,PF.phsC.units.multiplier,PF.phsC.db,PF.phsC.rangeC.min.f,PF.phsC.rangeC.max.f,V1.neut.units.multiplier,V1.neut.db,V1.neut.rangeC.min.f,V1.neut.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0A] - IN Derived Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 09] - IN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 09] - IN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 02] - IA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 01] - IA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 01] - IA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 04] - IB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 03] - IB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 03] - IB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 06] - IC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 05] - IC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 05] - IC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>ISEF Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0C] - ISEF Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 0B] - ISEF Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 0B] - ISEF Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Mutual Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 33] - IM Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 32] - IM Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 32] - IM Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Hz">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 2D] - Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 2D] - Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PF">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 0F] - APh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 0F] - APh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 10] - BPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 10] - BPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 11] - CPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 11] - CPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>Derived Voltage Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1B] - VAN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1A] - VAN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1A] - VAN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1D] - VBN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1C] - VBN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1C] - VBN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1F] - VCN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1E] - VCN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1E] - VCN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PPV">
              <SDI name="phsAB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 15] - VAB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 14] - VAB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 14] - VAB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsBC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 17] - VBC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 16] - VBC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 16] - VBC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsCA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 19] - VCA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 18] - VCA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 18] - VCA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="TotPF">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0E] - 3Ph Power Factor" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI name="SIUnit" valKind="RO">
                  <Val>cos(phi)</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI name="TotVA">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0C] - 3 Phase VA" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0C] - 3 Phase VA" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotVAr">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0B] - 3 Phase VArs" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0B] - 3 Phase VArs" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotW">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0A] - 3 Phase Watts" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0A] - 3 Phase Watts" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="V1">
              <DAI desc="[02 22] - VN Derived Mag" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 23] - VN Derived Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 22] - VN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 22] - VN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VA">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 07] - A Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 07] - A Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 08] - B Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 08] - B Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 09] - C Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 09] - C Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VAr">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 04] - A Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 04] - A Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 05] - B Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 05] - B Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 06] - C Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 06] - C Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="W">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 01] - A Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 01] - A Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 02] - B Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 02] - B Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 03] - C Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 03] - C Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Primary based metering quantities" lnType="MMTR_PRIV$_44ae7d31-7456-4aba-9519-736349426bea" inst="1" lnClass="MMTR" prefix="Pri">
            <Private type="MiCOM-ConfigurableAttributes">MTRRs.ctlModel,MTRRs.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DmdVArh">
              <DAI desc="[03 15] - 3Ph VArHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="DmdWh">
              <DAI desc="[03 13] - 3Ph WHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="MTRRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[03 25] - Reset Demand" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SupVArh">
              <DAI desc="[03 14] - 3Ph VArHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="SupWh">
              <DAI desc="[03 12] - 3Ph WHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotVArh">
              <DAI desc="[FE D5] - 3 Phase Vars" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotWh">
              <DAI desc="[FE D4] - 3 Phase Watts" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Sequence Measurements" lnType="MSQI_ALL" inst="1" lnClass="MSQI" prefix="Pri">
            <Private type="MiCOM-ConfigurableAttributes">SeqA.c1.db,SeqA.c2.db,SeqA.c3.db,SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqA.c1.units.multiplier,SeqA.c2.units.multiplier,SeqA.c3.units.multiplier,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqA.c1.rangeC.min.f,SeqA.c1.rangeC.max.f,SeqA.c2.rangeC.min.f,SeqA.c2.rangeC.max.f,SeqA.c3.rangeC.min.f,SeqA.c3.rangeC.max.f,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Sequence and Imbalance Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqA">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 41] - I1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 40] - I1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 40] - I1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 43] - I2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 42] - I2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 42] - I2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 45] - I0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 44] - I0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 44] - I0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 47] - V1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 46] - V1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 46] - V1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 49] - V2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 48] - V2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 48] - V2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 4B] - V0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 4A] - V0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 4A] - V0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary Metering Statistics" lnType="MSTA_I_W_VAR" inst="1" lnClass="MSTA" prefix="Pri">
            <Private type="MiCOM-ConfigurableAttributes">AvAmps1.db,AvAmps2.db,AvAmps3.db,AvAmps4.db,AvAmps5.db,AvAmps6.db,MaxAmps1.db,MaxAmps2.db,MaxAmps3.db,AvW1.db,AvW2.db,MaxW.db,AvVAr1.db,AvVAr2.db,MaxVAr.db,AvAmps1.rangeC.min.f,AvAmps1.rangeC.max.f,AvAmps2.rangeC.min.f,AvAmps2.rangeC.max.f,AvAmps3.rangeC.min.f,AvAmps3.rangeC.max.f,AvAmps4.rangeC.min.f,AvAmps4.rangeC.max.f,AvAmps5.rangeC.min.f,AvAmps5.rangeC.max.f,AvAmps6.rangeC.min.f,AvAmps6.rangeC.max.f,MaxAmps1.rangeC.min.f,MaxAmps1.rangeC.max.f,MaxAmps2.rangeC.min.f,MaxAmps2.rangeC.max.f,MaxAmps3.rangeC.min.f,MaxAmps3.rangeC.max.f,AvW1.rangeC.min.f,AvW1.rangeC.max.f,AvW2.rangeC.min.f,AvW2.rangeC.max.f,MaxW.rangeC.min.f,MaxW.rangeC.max.f,AvVAr1.rangeC.min.f,AvVAr1.rangeC.max.f,AvVAr2.rangeC.min.f,AvVAr2.rangeC.max.f,MaxVAr.rangeC.min.f,MaxVAr.rangeC.max.f,AvAmps1.units.multiplier,AvAmps2.units.multiplier,AvAmps3.units.multiplier,AvAmps4.units.multiplier,AvAmps5.units.multiplier,AvAmps6.units.multiplier,MaxAmps1.units.multiplier,MaxAmps2.units.multiplier,MaxAmps3.units.multiplier,AvW1.units.multiplier,AvW2.units.multiplier,MaxW.units.multiplier,AvVAr1.units.multiplier,AvVAr2.units.multiplier,MaxVAr.units.multiplier,</Private>
            <DOI name="AvAmps1">
              <DAI desc="[03 18] - IA Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 18] - IA Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 18] - IA Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps2">
              <DAI desc="[03 19] - IB Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 19] - IB Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 19] - IB Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps3">
              <DAI desc="[03 1A] - IC Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1A] - IC Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1A] - IC Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps4">
              <DAI desc="[03 1D] - IA Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1D] - IA Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1D] - IA Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps5">
              <DAI desc="[03 1E] - IB Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1E] - IB Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1E] - IB Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps6">
              <DAI desc="[03 1F] - IC Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1F] - IC Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1F] - IC Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr1">
              <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr2">
              <DAI desc="[03 1C] - 3Ph VArs RollDem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW1">
              <DAI desc="[03 16] - 3Ph W Fix Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW2">
              <DAI desc="[03 1B] - 3Ph W Roll Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="MaxAmps1">
              <DAI desc="[03 22] - IA Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 22] - IA Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 22] - IA Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps2">
              <DAI desc="[03 23] - IB Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 23] - IB Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 23] - IB Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps3">
              <DAI desc="[03 24] - IC Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 24] - IC Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 24] - IC Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxVAr">
              <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxW">
              <DAI desc="[03 20] - 3Ph W Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Metering Statistics</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Primary RMS Measurements" lnType="MMXU_RMS" inst="1" lnClass="MMXU" prefix="PriRms">
            <Private type="MiCOM-ConfigurableAttributes">PhV.phsA.db,PhV.phsB.db,PhV.phsC.db,A.phsA.db,A.phsB.db,A.phsC.db,PhV.phsB.units.multiplier,PhV.phsC.units.multiplier,A.phsA.units.multiplier,A.phsB.units.multiplier,A.phsC.units.multiplier,PhV.phsA.units.multiplier,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A.phsA.rangeC.min.f,A.phsA.rangeC.max.f,A.phsB.rangeC.min.f,A.phsB.rangeC.max.f,A.phsC.rangeC.min.f,A.phsC.rangeC.max.f,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,</Private>
            <DOI name="A">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 10] - IA RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 10] - IA RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 11] - IB RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 11] - IB RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 12] - IC RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 12] - IC RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 27] - VAN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 27] - VAN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 28] - VBN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 28] - VBN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 29] - VCN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 29] - VCN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Primary Compensated Overvoltage Measurements" lnType="MSQI_VOLTAGE" inst="1" lnClass="MSQI" prefix="PriVcp">
            <Private type="MiCOM-ConfigurableAttributes">SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Compensated Overvoltage Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 51] - V1 Rem Phase Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 50] - V1 Rem Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 50] - V1 Rem Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Current Differential Measurements" lnType="MMXU_INDIFF" inst="1" lnClass="MMXU" prefix="SecDif">
            <Private type="MiCOM-ConfigurableAttributes">A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.phsA.units.multiplier,A2.phsA.db,A2.phsA.rangeC.min.f,A2.phsA.rangeC.max.f,A2.phsB.units.multiplier,A2.phsB.db,A2.phsB.rangeC.min.f,A2.phsB.rangeC.max.f,A2.phsC.units.multiplier,A2.phsC.db,A2.phsC.rangeC.min.f,A2.phsC.rangeC.max.f,A2.neut.units.multiplier,A2.neut.db,A2.neut.rangeC.min.f,A2.neut.rangeC.max.f,A3.phsA.units.multiplier,A3.phsA.db,A3.phsA.rangeC.min.f,A3.phsA.rangeC.max.f,A3.phsB.units.multiplier,A3.phsB.db,A3.phsB.rangeC.min.f,A3.phsB.rangeC.max.f,A3.phsC.units.multiplier,A3.phsC.db,A3.phsC.rangeC.min.f,A3.phsC.rangeC.max.f,A3.neut.units.multiplier,A3.neut.db,A3.neut.rangeC.min.f,A3.neut.rangeC.max.f,A4.phsA.units.multiplier,A4.phsA.db,A4.phsA.rangeC.min.f,A4.phsA.rangeC.max.f,A4.phsB.units.multiplier,A4.phsB.db,A4.phsB.rangeC.min.f,A4.phsB.rangeC.max.f,A4.phsC.units.multiplier,A4.phsC.db,A4.phsC.rangeC.min.f,A4.phsC.rangeC.max.f,A4.neut.units.multiplier,A4.neut.db,A4.neut.rangeC.min.f,A4.neut.rangeC.max.f,A5.phsA.units.multiplier,A5.phsA.db,A5.phsA.rangeC.min.f,A5.phsA.rangeC.max.f,A5.phsB.units.multiplier,A5.phsB.db,A5.phsB.rangeC.min.f,A5.phsB.rangeC.max.f,A5.phsC.units.multiplier,A5.phsC.db,A5.phsC.rangeC.min.f,A5.phsC.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Local Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 07] - IN local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 07] - IN local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 02] - IA Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 01] - IA local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 01] - IA local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 04] - IB Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 03] - IB local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 03] - IB local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 06] - IC Angle local" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 05] - IC local" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 05] - IC local" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>Remote CH1 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 0F] - IN remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0F] - IN remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0A] - IA Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 09] - IA remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 09] - IA remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0C] - IB Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0B] - IB remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0B] - IB remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 0E] - IC Ang remote 1" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 0D] - IC remote 1" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 0D] - IC remote 1" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Remote CH2 Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 17] - IN remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 17] - IN remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 12] - IA Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 11] - IA remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 11] - IA remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 14] - IB Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 13] - IB remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 13] - IB remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[04 16] - IC Ang remote 2" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[04 15] - IC remote 2" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 15] - IC remote 2" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A4">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1C] - IN Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1C] - IN Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 19] - IA Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 19] - IA Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1A] - IB Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1A] - IB Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1B] - IC Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1B] - IC Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A5">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Current Differential Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Fourier Measurements" lnType="MMXU_FOURIER" inst="1" lnClass="MMXU" prefix="SecFou">
            <Private type="MiCOM-ConfigurableAttributes">TotW.units.multiplier,TotW.db,TotW.rangeC.min.f,TotW.rangeC.max.f,TotVAr.units.multiplier,TotVAr.db,TotVAr.rangeC.min.f,TotVAr.rangeC.max.f,TotVA.units.multiplier,TotVA.db,TotVA.rangeC.min.f,TotVA.rangeC.max.f,TotPF.units.multiplier,TotPF.db,TotPF.rangeC.min.f,TotPF.rangeC.max.f,Hz.units.multiplier,Hz.db,Hz.rangeC.min.f,Hz.rangeC.max.f,PPV.phsAB.units.multiplier,PPV.phsAB.db,PPV.phsAB.rangeC.min.f,PPV.phsAB.rangeC.max.f,PPV.phsBC.units.multiplier,PPV.phsBC.db,PPV.phsBC.rangeC.min.f,PPV.phsBC.rangeC.max.f,PPV.phsCA.units.multiplier,PPV.phsCA.db,PPV.phsCA.rangeC.min.f,PPV.phsCA.rangeC.max.f,PhV.phsA.units.multiplier,PhV.phsA.db,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,PhV.phsB.units.multiplier,PhV.phsB.db,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.units.multiplier,PhV.phsC.db,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A1.phsA.units.multiplier,A1.phsA.db,A1.phsA.rangeC.min.f,A1.phsA.rangeC.max.f,A1.phsB.units.multiplier,A1.phsB.db,A1.phsB.rangeC.min.f,A1.phsB.rangeC.max.f,A1.phsC.units.multiplier,A1.phsC.db,A1.phsC.rangeC.min.f,A1.phsC.rangeC.max.f,A1.neut.units.multiplier,A1.neut.db,A1.neut.rangeC.min.f,A1.neut.rangeC.max.f,A2.res.units.multiplier,A2.res.db,A2.res.rangeC.min.f,A2.res.rangeC.max.f,A3.res.units.multiplier,A3.res.db,A3.res.rangeC.min.f,A3.res.rangeC.max.f,W.phsA.units.multiplier,W.phsA.db,W.phsA.rangeC.min.f,W.phsA.rangeC.max.f,W.phsB.units.multiplier,W.phsB.db,W.phsB.rangeC.min.f,W.phsB.rangeC.max.f,W.phsC.units.multiplier,W.phsC.db,W.phsC.rangeC.min.f,W.phsC.rangeC.max.f,VAr.phsA.units.multiplier,VAr.phsA.db,VAr.phsA.rangeC.min.f,VAr.phsA.rangeC.max.f,VAr.phsB.units.multiplier,VAr.phsB.db,VAr.phsB.rangeC.min.f,VAr.phsB.rangeC.max.f,VAr.phsC.units.multiplier,VAr.phsC.db,VAr.phsC.rangeC.min.f,VAr.phsC.rangeC.max.f,VA.phsA.units.multiplier,VA.phsA.db,VA.phsA.rangeC.min.f,VA.phsA.rangeC.max.f,VA.phsB.units.multiplier,VA.phsB.db,VA.phsB.rangeC.min.f,VA.phsB.rangeC.max.f,VA.phsC.units.multiplier,VA.phsC.db,VA.phsC.rangeC.min.f,VA.phsC.rangeC.max.f,PF.phsA.units.multiplier,PF.phsA.db,PF.phsA.rangeC.min.f,PF.phsA.rangeC.max.f,PF.phsB.units.multiplier,PF.phsB.db,PF.phsB.rangeC.min.f,PF.phsB.rangeC.max.f,PF.phsC.units.multiplier,PF.phsC.db,PF.phsC.rangeC.min.f,PF.phsC.rangeC.max.f,V1.neut.units.multiplier,V1.neut.db,V1.neut.rangeC.min.f,V1.neut.rangeC.max.f,</Private>
            <DOI name="A1">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0A] - IN Derived Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 09] - IN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 09] - IN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 02] - IA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 01] - IA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 01] - IA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 04] - IB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 03] - IB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 03] - IB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 06] - IC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 05] - IC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 05] - IC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A2">
              <DAI name="d" valKind="RO">
                <Val>ISEF Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 0C] - ISEF Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 0B] - ISEF Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 0B] - ISEF Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="A3">
              <DAI name="d" valKind="RO">
                <Val>Mutual Measurements</Val>
              </DAI>
              <SDI name="res">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 33] - IM Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 32] - IM Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 32] - IM Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Hz">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[02 2D] - Frequency" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>70</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>40</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 2D] - Frequency" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PF">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 0F] - APh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 0F] - APh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 10] - BPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 10] - BPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 11] - CPh Power Factor" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>1</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 11] - CPh Power Factor" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>Derived Voltage Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1B] - VAN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1A] - VAN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1A] - VAN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1D] - VBN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1C] - VBN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1C] - VBN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 1F] - VCN Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 1E] - VCN Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 1E] - VCN Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="PPV">
              <SDI name="phsAB">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 15] - VAB Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 14] - VAB Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 14] - VAB Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsBC">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 17] - VBC Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 16] - VBC Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 16] - VBC Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsCA">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 19] - VCA Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 18] - VCA Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>380</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 18] - VCA Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="TotPF">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0E] - 3Ph Power Factor" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI name="SIUnit" valKind="RO">
                  <Val>cos(phi)</Val>
                </DAI>
              </SDI>
            </DOI>
            <DOI name="TotVA">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0C] - 3 Phase VA" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0C] - 3 Phase VA" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotVAr">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0B] - 3 Phase VArs" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0B] - 3 Phase VArs" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="TotW">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 0A] - 3 Phase Watts" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 0A] - 3 Phase Watts" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="V1">
              <DAI desc="[02 22] - VN Derived Mag" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 23] - VN Derived Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 22] - VN Derived Mag" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 22] - VN Derived Mag" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VA">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 07] - A Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 07] - A Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 08] - B Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 08] - B Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 09] - C Phase VA" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 09] - C Phase VA" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="VAr">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 04] - A Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 04] - A Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 05] - B Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 05] - B Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 06] - C Phase VArs" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 06] - C Phase VArs" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="W">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 01] - A Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 01] - A Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 02] - B Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 02] - B Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[03 03] - C Phase Watts" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>660</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[03 03] - C Phase Watts" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Secondary based metering quantities" lnType="MMTR_PRIV$_44ae7d31-7456-4aba-9519-736349426bea" inst="1" lnClass="MMTR" prefix="Sec">
            <Private type="MiCOM-ConfigurableAttributes">MTRRs.ctlModel,MTRRs.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DmdVArh">
              <DAI desc="[03 15] - 3Ph VArHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="DmdWh">
              <DAI desc="[03 13] - 3Ph WHours Rev" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="MTRRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[03 25] - Reset Demand" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fourier Based Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SupVArh">
              <DAI desc="[03 14] - 3Ph VArHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="SupWh">
              <DAI desc="[03 12] - 3Ph WHours Fwd" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotVArh">
              <DAI desc="[FE D7] - 3 Phase Vars" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
            <DOI name="TotWh">
              <DAI desc="[FE D6] - 3 Phase Watts" name="actVal" valKind="RO"/>
              <DAI name="pulsQty" valKind="RO">
                <Val>1000</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Sequence Measurements" lnType="MSQI_ALL" inst="1" lnClass="MSQI" prefix="Sec">
            <Private type="MiCOM-ConfigurableAttributes">SeqA.c1.db,SeqA.c2.db,SeqA.c3.db,SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqA.c2.units.multiplier,SeqA.c3.units.multiplier,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqA.c1.units.multiplier,SeqA.c2.rangeC.min.f,SeqA.c2.rangeC.max.f,SeqA.c3.rangeC.min.f,SeqA.c3.rangeC.max.f,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,SeqA.c1.rangeC.min.f,SeqA.c1.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Sequence and Imbalance Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqA">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 41] - I1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 40] - I1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 40] - I1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 43] - I2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 42] - I2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 42] - I2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 45] - I0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 44] - I0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 44] - I0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 47] - V1 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 46] - V1 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 46] - V1 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 49] - V2 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 48] - V2 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 48] - V2 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 4B] - V0 Phase Angle" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 4A] - V0 Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 4A] - V0 Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary Metering Statistics" lnType="MSTA_I_W_VAR" inst="1" lnClass="MSTA" prefix="Sec">
            <Private type="MiCOM-ConfigurableAttributes">AvAmps1.db,AvAmps2.db,AvAmps3.db,AvAmps4.db,AvAmps5.db,AvAmps6.db,MaxAmps1.db,MaxAmps2.db,MaxAmps3.db,AvW1.db,AvW2.db,MaxW.db,AvVAr1.db,AvVAr2.db,MaxVAr.db,AvAmps1.rangeC.min.f,AvAmps1.rangeC.max.f,AvAmps2.rangeC.min.f,AvAmps2.rangeC.max.f,AvAmps3.rangeC.min.f,AvAmps3.rangeC.max.f,AvAmps4.rangeC.min.f,AvAmps4.rangeC.max.f,AvAmps5.rangeC.min.f,AvAmps5.rangeC.max.f,AvAmps6.rangeC.min.f,AvAmps6.rangeC.max.f,MaxAmps1.rangeC.min.f,MaxAmps1.rangeC.max.f,MaxAmps2.rangeC.min.f,MaxAmps2.rangeC.max.f,MaxAmps3.rangeC.min.f,MaxAmps3.rangeC.max.f,AvW1.rangeC.min.f,AvW1.rangeC.max.f,AvW2.rangeC.min.f,AvW2.rangeC.max.f,MaxW.rangeC.min.f,MaxW.rangeC.max.f,AvVAr1.rangeC.min.f,AvVAr1.rangeC.max.f,AvVAr2.rangeC.min.f,AvVAr2.rangeC.max.f,MaxVAr.rangeC.min.f,MaxVAr.rangeC.max.f,AvAmps1.units.multiplier,AvAmps2.units.multiplier,AvAmps3.units.multiplier,AvAmps4.units.multiplier,AvAmps5.units.multiplier,AvAmps6.units.multiplier,MaxAmps1.units.multiplier,MaxAmps2.units.multiplier,MaxAmps3.units.multiplier,AvW1.units.multiplier,AvW2.units.multiplier,MaxW.units.multiplier,AvVAr1.units.multiplier,AvVAr2.units.multiplier,MaxVAr.units.multiplier,</Private>
            <DOI name="AvAmps1">
              <DAI desc="[03 18] - IA Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 18] - IA Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 18] - IA Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps2">
              <DAI desc="[03 19] - IB Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 19] - IB Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 19] - IB Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps3">
              <DAI desc="[03 1A] - IC Fixed Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1A] - IC Fixed Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1A] - IC Fixed Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps4">
              <DAI desc="[03 1D] - IA Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1D] - IA Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1D] - IA Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps5">
              <DAI desc="[03 1E] - IB Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1E] - IB Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1E] - IB Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvAmps6">
              <DAI desc="[03 1F] - IC Roll Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1F] - IC Roll Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1F] - IC Roll Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr1">
              <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 17] - 3Ph VArs Fix Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvVAr2">
              <DAI desc="[03 1C] - 3Ph VArs RollDem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1C] - 3Ph VArs RollDem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW1">
              <DAI desc="[03 16] - 3Ph W Fix Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 16] - 3Ph W Fix Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="AvW2">
              <DAI desc="[03 1B] - 3Ph W Roll Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 1B] - 3Ph W Roll Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="MaxAmps1">
              <DAI desc="[03 22] - IA Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 22] - IA Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 22] - IA Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps2">
              <DAI desc="[03 23] - IB Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 23] - IB Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 23] - IB Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxAmps3">
              <DAI desc="[03 24] - IC Peak Demand" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 24] - IC Peak Demand" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 24] - IC Peak Demand" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxVAr">
              <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 21] - 3Ph VAr Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="MaxW">
              <DAI desc="[03 20] - 3Ph W Peak Dem" name="d" valKind="Set"/>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>660</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 20] - 3Ph W Peak Dem" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Metering Statistics</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Secondary RMS Measurements" lnType="MMXU_RMS" inst="1" lnClass="MMXU" prefix="SecRms">
            <Private type="MiCOM-ConfigurableAttributes">PhV.phsA.db,PhV.phsB.db,PhV.phsC.db,A.phsA.db,A.phsB.db,A.phsC.db,PhV.phsA.units.multiplier,PhV.phsB.units.multiplier,PhV.phsC.units.multiplier,A.phsA.units.multiplier,A.phsB.units.multiplier,A.phsC.units.multiplier,PhV.phsA.rangeC.min.f,PhV.phsA.rangeC.max.f,PhV.phsB.rangeC.min.f,PhV.phsB.rangeC.max.f,PhV.phsC.rangeC.min.f,PhV.phsC.rangeC.max.f,A.phsA.rangeC.min.f,A.phsA.rangeC.max.f,A.phsB.rangeC.min.f,A.phsB.rangeC.max.f,A.phsC.rangeC.min.f,A.phsC.rangeC.max.f,</Private>
            <DOI name="A">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 10] - IA RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 10] - IA RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 11] - IB RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 11] - IB RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 12] - IC RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 12] - IC RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="PhV">
              <DAI name="d" valKind="RO">
                <Val>RMS Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 27] - VAN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 27] - VAN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 28] - VBN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 28] - VBN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[02 29] - VCN RMS" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 29] - VCN RMS" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Secondary Compensated Overvoltage Measurements" lnType="MSQI_VOLTAGE" inst="1" lnClass="MSQI" prefix="SecVcp">
            <Private type="MiCOM-ConfigurableAttributes">SeqV.c1.db,SeqV.c2.db,SeqV.c3.db,SeqV.c1.units.multiplier,SeqV.c2.units.multiplier,SeqV.c3.units.multiplier,SeqV.c1.rangeC.min.f,SeqV.c1.rangeC.max.f,SeqV.c2.rangeC.min.f,SeqV.c2.rangeC.max.f,SeqV.c3.rangeC.min.f,SeqV.c3.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Compensated Overvoltage Measurements</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SeqV">
              <SDI name="c1">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI desc="[02 51] - V1 Rem Phase Ang" name="f" valKind="RO"/>
                  </SDI>
                  <SDI name="mag">
                    <DAI desc="[02 50] - V1 Rem Magnitude" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[02 50] - V1 Rem Magnitude" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="c2">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="c3">
                <SDI name="cVal">
                  <SDI name="ang">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="mag">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>220</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI name="SIUnit" valKind="RO">
                    <Val>V</Val>
                  </DAI>
                </SDI>
              </SDI>
              <DAI name="seqT" valKind="RO">
                <Val>pos-neg-zero</Val>
              </DAI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="Protection Domain" inst="Protection">
          <LN0 desc="Protection Logical Device" lnType="LLN0_PROT$_0dcd529d-5792-4714-82ca-596f8c048fa4" inst="" lnClass="LLN0">
            <Private type="MiCOM-ConfigurableAttributes">DisMod.ctlModel,DifMod.ctlModel,OcpMod.ctlModel,NgcMod.ctlModel,EfdMod.ctlModel,SefMod.ctlModel,VtpMod.ctlModel,NvdMod.ctlModel,FrqMod.ctlModel,DfpMod.ctlModel,ThmMod.ctlModel,CbfMod.ctlModel,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CbfBeh">
              <DAI desc="[09 20] - CB Fail" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 20] - CB Fail" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CbfMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 20] - CB Fail" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 20] - CB Fail" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DfpBeh">
              <DAI desc="[09 1F] - df/dt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 1F] - df/dt Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DfpMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 1F] - df/dt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 1F] - df/dt Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifBeh">
              <DAI desc="[09 0F] - Phase Diff" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 0F] - Phase Diff" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 0F] - Phase Diff" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 0F] - Phase Diff" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DisBeh">
              <DAI desc="[09 0B] - Distance" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 0B] - Distance" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DisMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 0B] - Distance" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 0B] - Distance" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EfdBeh">
              <DAI desc="[09 13] - Earth Fault" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 13] - Earth Fault" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="EfdMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 13] - Earth Fault" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 13] - Earth Fault" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FrqBeh">
              <DAI desc="[09 1E] - Freq Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 1E] - Freq Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FrqMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 1E] - Freq Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 1E] - Freq Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Protection Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="NgcBeh">
              <DAI desc="[09 11] - Neg Sequence O/C" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 11] - Neg Sequence O/C" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NgcMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 11] - Neg Sequence O/C" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 11] - Neg Sequence O/C" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NvdBeh">
              <DAI desc="[09 16] - Residual O/V NVD" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 16] - Residual O/V NVD" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NvdMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 16] - Residual O/V NVD" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 16] - Residual O/V NVD" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="OcpBeh">
              <DAI desc="[09 10] - Overcurrent" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 10] - Overcurrent" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="OcpMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 10] - Overcurrent" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 10] - Overcurrent" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SefBeh">
              <DAI desc="[09 15] - SEF/REF Prot'n" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 15] - SEF/REF Prot'n" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SefMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 15] - SEF/REF Prot'n" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 15] - SEF/REF Prot'n" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ThmBeh">
              <DAI desc="[09 17] - Thermal Overload" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 17] - Thermal Overload" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ThmMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 17] - Thermal Overload" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 17] - Thermal Overload" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VtpBeh">
              <DAI desc="[09 1D] - Volt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[09 1D] - Volt Protection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="VtpMod">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 1D] - Volt Protection" name="d" valKind="RO"/>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI desc="[09 1D] - Volt Protection" name="stVal" valKind="RO"/>
            </DOI>
          </LN0>
          <LN desc="Circuit Breaker 1 Failure Stage 1" lnType="RBRF_EXTTRP_SEG" inst="1" lnClass="RBRF" prefix="Cbf">
            <DOI name="Beh">
              <DAI desc="[FE 09] - CbfRBRF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[45 02] - CB Fail 1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[45 02] - CB Fail 1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpEx">
              <DAI desc="DDB Ordinal: 834" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1672" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1673" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1674" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Circuit Breaker 1 Failure Stage 2" lnType="RBRF_EXTTRP_SEG" inst="2" lnClass="RBRF" prefix="Cbf">
            <DOI name="Beh">
              <DAI desc="[FE 0A] - CbfRBRF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[45 04] - CB Fail 2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[45 04] - CB Fail 2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OpEx">
              <DAI desc="DDB Ordinal: 835" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1675" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1676" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1677" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 1 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="1" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 50] - DfpPFRC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 04] - df/dt>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 04] - df/dt>1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 601" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 597" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 2 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="2" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 51] - DfpPFRC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 0B] - df/dt>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 0B] - df/dt>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 602" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 598" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 3 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="3" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 52] - DfpPFRC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 12] - df/dt>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 12] - df/dt>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 603" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 599" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="df/dt> 4 Frequency Rate of Change" lnType="PFRC_NO_SEG" inst="4" lnClass="PFRC" prefix="Dfp">
            <DOI name="Beh">
              <DAI desc="[FE 53] - DfpPFRC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[44 19] - df/dt>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[44 19] - df/dt>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 604" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 600" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Current Differential" lnType="PDIF_BASIC" inst="1" lnClass="PDIF" prefix="Dif">
            <Private type="MiCOM-ConfigurableAttributes">DifAClc.phsA.db,DifAClc.phsB.db,DifAClc.phsC.db,RstA.phsA.db,RstA.phsB.db,RstA.phsC.db,DifAClc.phsA.units.multiplier,DifAClc.phsB.units.multiplier,DifAClc.phsC.units.multiplier,RstA.phsA.units.multiplier,RstA.phsB.units.multiplier,RstA.phsC.units.multiplier,DifAClc.phsA.rangeC.min.f,DifAClc.phsA.rangeC.max.f,DifAClc.phsB.rangeC.min.f,DifAClc.phsB.rangeC.max.f,DifAClc.phsC.rangeC.min.f,DifAClc.phsC.rangeC.max.f,RstA.phsA.rangeC.min.f,RstA.phsA.rangeC.max.f,RstA.phsB.rangeC.min.f,RstA.phsB.rangeC.max.f,RstA.phsC.rangeC.min.f,RstA.phsC.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="[FE 1A] - DifPDIF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAClc">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 19] - IA Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 19] - IA Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1A] - IB Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1A] - IB Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1B] - IC Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1B] - IC Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[33 01] - Phase Diff" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[33 01] - Phase Diff" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 582" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 583" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 584" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 585" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="RstA">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 737" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 738" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 739" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 740" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Neutral Current Differential" lnType="PDIF_NEUT_DIFF" inst="2" lnClass="PDIF" prefix="Dif">
            <Private type="MiCOM-ConfigurableAttributes">DifAClc.neut.units.multiplier,DifAClc.neut.db,DifAClc.neut.rangeC.min.f,DifAClc.neut.rangeC.max.f,RstA.phsA.units.multiplier,RstA.phsA.db,RstA.phsA.rangeC.min.f,RstA.phsA.rangeC.max.f,RstA.phsB.units.multiplier,RstA.phsB.db,RstA.phsB.rangeC.min.f,RstA.phsB.rangeC.max.f,RstA.phsC.units.multiplier,RstA.phsC.db,RstA.phsC.rangeC.min.f,RstA.phsC.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="[FE 37] - DifPDIF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DifAClc">
              <DAI name="d" valKind="RO">
                <Val>Differential Measurements</Val>
              </DAI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1C] - IN Differential" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1C] - IN Differential" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[33 40] - In Diff Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[33 3F] - NEUTRAL DIFF" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1694" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1694" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="RstA">
              <DAI name="d" valKind="RO">
                <Val>Bias Measurements</Val>
              </DAI>
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1D] - IA Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1D] - IA Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1E] - IB Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1E] - IB Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI name="mag">
                    <DAI desc="[04 1F] - IC Bias" name="f" valKind="RO"/>
                  </SDI>
                </SDI>
                <DAI name="db" valKind="Set">
                  <Val>1000</Val>
                </DAI>
                <SDI name="rangeC">
                  <SDI name="hhLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="hLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="lLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="llLim">
                    <DAI name="f" valKind="RO">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                  <SDI name="max">
                    <DAI name="f" valKind="Set">
                      <Val>3</Val>
                    </DAI>
                  </SDI>
                  <SDI name="min">
                    <DAI name="f" valKind="Set">
                      <Val>0</Val>
                    </DAI>
                  </SDI>
                </SDI>
                <SDI name="units">
                  <DAI name="multiplier" valKind="Set">
                    <Val></Val>
                  </DAI>
                  <DAI desc="[04 1F] - IC Bias" name="SIUnit" valKind="RO"/>
                </SDI>
              </SDI>
            </DOI>
            <DOI name="Str1">
              <DAI desc="DDB Ordinal: 1692" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1692" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1692" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str2">
              <DAI desc="DDB Ordinal: 1693" name="d" valKind="RO"/>
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1693" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1693" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 1 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="1" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 1C] - DisPDIS1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 1B] - DisPDIS1.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 1 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 608" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 612" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 609" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 610" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 611" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="Returns the Distance Zone 1 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 744" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 741" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 742" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 743" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 2 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="2" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 1E] - DisPDIS2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 1D] - DisPDIS2.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 2 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 613" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 617" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 614" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 615" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 616" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>forward</Val>
              </DAI>
              <DAI desc="Returns the Distance Zone 2 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 748" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 745" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 746" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 747" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 3 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="3" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 20] - DisPDIS3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 1F] - DisPDIS3.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 3 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 618" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 622" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 619" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 620" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 621" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirGeneral" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirNeut" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirPhsA" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirPhsB" valKind="RO"/>
              <DAI desc="[FE 25] - DisPDIS3.ST.Directions" name="dirPhsC" valKind="RO"/>
              <DAI desc="Returns the Distance Zone 3 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 752" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 749" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 750" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 751" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone 4 Ph/Gnd Distance" lnType="PDIS_BASIC" inst="4" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 22] - DisPDIS4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 21] - DisPDIS4.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone 4 Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 628" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 632" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 629" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 630" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 631" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>backward</Val>
              </DAI>
              <DAI desc="Returns the Distance Zone 4 Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 760" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 757" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 758" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 759" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Zone P Ph/Gnd Distance" lnType="PDIS_BASIC" inst="5" lnClass="PDIS" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[FE 24] - DisPDIS5.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[FE 23] - DisPDIS5.ST.Mod.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Zone P Ph/Gnd Distance</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 623" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 627" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 624" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 625" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 626" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirGeneral" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirNeut" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirPhsA" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirPhsB" valKind="RO"/>
              <DAI desc="[FE 26] - DisPDIS5.ST.Directions" name="dirPhsC" valKind="RO"/>
              <DAI desc="Returns the Distance Zone P Start Status of all 3 Phases." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 756" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 753" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 754" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 755" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Distance Protection Scheme 1" lnType="PSCH_BASIC" inst="1" lnClass="PSCH" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[34 41] - Aid. 1 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CarRx">
              <DAI desc="DDB Ordinal: 494" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="LosOfGrd">
              <DAI desc="DDB Ordinal: 492" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 41] - Aid. 1 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 40] - AIDED SCHEME 1" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="Returns the Trip Status of Scheme 1." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 636" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 633" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 634" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 635" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="ProRx">
              <DAI desc="DDB Ordinal: 493" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ProTx">
              <DAI desc="DDB Ordinal: 498" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 498" name="general" valKind="RO"/>
            </DOI>
            <DOI name="WeiOp">
              <DAI desc="Returns the Trip of all 3 Phases for the Weak End Infeed Function for Scheme 1." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 637" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 638" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 639" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Distance Protection Scheme 2" lnType="PSCH_BASIC" inst="2" lnClass="PSCH" prefix="Dis">
            <DOI name="Beh">
              <DAI desc="[34 61] - Aid. 2 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="CarRx">
              <DAI desc="DDB Ordinal: 508" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="LosOfGrd">
              <DAI desc="DDB Ordinal: 506" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 61] - Aid. 2 Selection" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 60] - AIDED SCHEME 2" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="Returns the Trip Status of Scheme 2." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 646" name="neut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 643" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 644" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 645" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="ProRx">
              <DAI desc="DDB Ordinal: 507" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="ProTx">
              <DAI desc="DDB Ordinal: 514" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 514" name="general" valKind="RO"/>
            </DOI>
            <DOI name="WeiOp">
              <DAI desc="Returns the Trip of all 3 Phases for the Weak End Infeed Function for Scheme 2." name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 647" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 648" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 649" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 1 Earth Fault (Derived)" lnType="PTOC_NEU" inst="1" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0B] - EfdPTOC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 01] - IN>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 25] - IN>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 671" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 671" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 26] - IN>1 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 26] - IN>1 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 777" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 777" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 2 Earth Fault (Derived)" lnType="PTOC_NEU" inst="2" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0C] - EfdPTOC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 35] - IN>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 36] - IN>2 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 672" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 672" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 37] - IN>2 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 37] - IN>2 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 778" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 778" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 3 Earth Fault (Derived)" lnType="PTOC_NEU" inst="3" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0D] - EfdPTOC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 46] - IN>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 46] - IN>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 673" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 673" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 47] - IN>3 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 47] - IN>3 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 779" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 779" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IN1> 4 Earth Fault (Derived)" lnType="PTOC_NEU" inst="4" lnClass="PTOC" prefix="Efd">
            <DOI name="Beh">
              <DAI desc="[FE 0E] - EfdPTOC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[38 4D] - IN>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[38 4D] - IN>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 674" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 674" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[38 4E] - IN>4 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[38 4E] - IN>4 Directional" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 780" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 780" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F> 1 Overfrequency" lnType="PTOF_NO_SEG" inst="1" lnClass="PTOF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 54] - FrqPTOF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 10] - F>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 10] - F>1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1165" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1159" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F> 2 Overfrequency" lnType="PTOF_NO_SEG" inst="2" lnClass="PTOF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 55] - FrqPTOF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 13] - F>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 13] - F>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1166" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1160" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 1 Underfrequency" lnType="PTUF_NO_SEG" inst="1" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 56] - FrqPTUF1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 02] - F&lt;1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 02] - F&lt;1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1161" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1155" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 2 Underfrequency" lnType="PTUF_NO_SEG" inst="2" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 57] - FrqPTUF2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 05] - F&lt;2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 05] - F&lt;2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1162" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1156" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 3 Underfrequency" lnType="PTUF_NO_SEG" inst="3" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 58] - FrqPTUF3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 08] - F&lt;3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 08] - F&lt;3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1163" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1157" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="F&lt; 4 Underfrequency" lnType="PTUF_NO_SEG" inst="4" lnClass="PTUF" prefix="Frq">
            <DOI name="Beh">
              <DAI desc="[FE 59] - FrqPTUF4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[43 0B] - F&lt;4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[43 0B] - F&lt;4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 1164" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 1158" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="I2> 1 Negative Sequence" lnType="PTOC_NO_SEG" inst="1" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 0F] - NgcPTOC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 10] - I2>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 10] - I2>1 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 571" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 12] - I2>1 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 567" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I2> 2 Negative Sequence" lnType="PTOC_NO_SEG" inst="2" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 32] - NgcPTOC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 20] - I2>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 20] - I2>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 572" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 22] - I2>2 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 568" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I2> 3 Negative Sequence" lnType="PTOC_NO_SEG" inst="3" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 33] - NgcPTOC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 30] - I2>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 30] - I2>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 573" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 32] - I2>3 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 569" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I2> 4 Negative Sequence" lnType="PTOC_NO_SEG" inst="4" lnClass="PTOC" prefix="Ngc">
            <DOI name="Beh">
              <DAI desc="[FE 34] - NgcPTOC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[36 40] - I2>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[36 40] - I2>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 574" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[36 42] - I2>4 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="DDB Ordinal: 570" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 1 Overcurrent" lnType="PTOC_SEG" inst="1" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 01] - OcpPTOC1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 01] - I>1 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 02] - I>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 655" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 656" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 657" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 658" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 03] - I>1 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 03] - I>1 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 03] - I>1 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 03] - I>1 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 761" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 762" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 763" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 764" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 2 Overcurrent" lnType="PTOC_SEG" inst="2" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 02] - OcpPTOC2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 0A] - I>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 0B] - I>2 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 659" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 660" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 661" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 662" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 0C] - I>2 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 0C] - I>2 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 0C] - I>2 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 0C] - I>2 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 765" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 766" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 767" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 768" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 3 Overcurrent" lnType="PTOC_SEG" inst="3" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 03] - OcpPTOC3.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 13] - I>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 13] - I>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 663" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 664" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 665" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 666" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 14] - I>3 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 14] - I>3 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 14] - I>3 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 14] - I>3 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 769" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 770" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 771" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 772" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="I> 4 Overcurrent" lnType="PTOC_SEG" inst="4" lnClass="PTOC" prefix="Ocp">
            <DOI name="Beh">
              <DAI desc="[FE 04] - OcpPTOC4.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[35 18] - I>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[35 18] - I>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 667" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 668" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 669" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 670" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[35 19] - I>4 Directional" name="dirGeneral" valKind="RO"/>
              <DAI desc="[35 19] - I>4 Directional" name="dirPhsA" valKind="RO"/>
              <DAI desc="[35 19] - I>4 Directional" name="dirPhsB" valKind="RO"/>
              <DAI desc="[35 19] - I>4 Directional" name="dirPhsC" valKind="RO"/>
              <DAI desc="DDB Ordinal: 773" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 774" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 775" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 776" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Protection Trip Conditioning" lnType="PTRC_NO_SEG" inst="1" lnClass="PTRC">
            <DOI name="Beh">
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Protection Trip Conditioning</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 736" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Tr">
              <DAI desc="DDB Ordinal: 522" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 1 Sensitive Earth Fault" lnType="PTOC_NEU" inst="1" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 16] - SefPTOC1.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 2A] - ISEF>1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 2A] - ISEF>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 675" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 675" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 2B] - ISEF>1 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 2B] - ISEF>1 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 781" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 781" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 2 Sensitive Earth Fault" lnType="PTOC_NEU" inst="2" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 17] - SefPTOC2.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 3A] - ISEF>2 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 3A] - ISEF>2 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 676" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 676" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 3B] - ISEF>2 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 3B] - ISEF>2 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 782" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 782" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 3 Sensitive Earth Fault" lnType="PTOC_NEU" inst="3" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 18] - SefPTOC3.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 49] - ISEF>3 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 49] - ISEF>3 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 677" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 677" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 4A] - ISEF>3 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 4A] - ISEF>3 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 783" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 783" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="ISEF> 4 Sensitive Earth Fault" lnType="PTOC_NEU" inst="4" lnClass="PTOC" prefix="SenEft">
            <DOI name="Beh">
              <DAI desc="[FE 19] - SefPTOC4.ST.Bah.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 50] - ISEF>4 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 50] - ISEF>4 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 678" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 678" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI desc="[3A 51] - ISEF>4 Direction" name="dirGeneral" valKind="RO"/>
              <DAI desc="[3A 51] - ISEF>4 Direction" name="dirNeut" valKind="RO"/>
              <DAI desc="DDB Ordinal: 784" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 784" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="IREF> 1 Restricted Earth Fault" lnType="PDIF_NEU" inst="1" lnClass="PDIF" prefix="SenRef">
            <DOI name="Beh">
              <DAI desc="[FE 30] - SenRefPDIF1.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3A 01] - SEF/REF Options" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3A 60] - RESTRICTED E/F" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 682" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 682" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Switch onto Fault protection" lnType="PSOF_MULTI_OP" inst="1" lnClass="PSOF" prefix="Sof">
            <DOI name="Beh">
              <DAI desc="[FE 29] - SofPSOF.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 81] - SOTF Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 81] - SOTF Status" name="d" valKind="RO"/>
              <DAI name="lnNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op1">
              <DAI desc="DDB Ordinal: 709" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 709" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op2">
              <DAI desc="DDB Ordinal: 710" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 710" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op3">
              <DAI desc="DDB Ordinal: 711" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 711" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op4">
              <DAI desc="DDB Ordinal: 712" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 712" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op5">
              <DAI desc="DDB Ordinal: 713" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 713" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op6">
              <DAI desc="DDB Ordinal: 558" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 558" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 879" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Thermal Overload" lnType="PTTR_NO_SEG$_b4615a36-b1bb-4f89-8100-6d4b2263553a" inst="1" lnClass="PTTR" prefix="Thm">
            <Private type="MiCOM-ConfigurableAttributes">MTRRs.ctlModel,MTRRs.sboTimeout,Amp.units.multiplier,Amp.db,Amp.rangeC.min.f,Amp.rangeC.max.f,TmpRl.units.multiplier,TmpRl.db,TmpRl.rangeC.min.f,TmpRl.rangeC.max.f,</Private>
            <DOI name="AlmThm">
              <DAI desc="DDB Ordinal: 785" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Amp">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[FE 08] - ThmPTTR1.MX.Amp.f" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>3</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[02 0D] - I1 Magnitude" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Beh">
              <DAI desc="[FE 07] - ThmPTTR1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3C 01] - Characteristic" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="MTRRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[03 27] - Reset Thermal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[09 17] - Thermal Overload" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 680" name="general" valKind="RO"/>
            </DOI>
            <DOI name="TmpRl">
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[03 26] - Thermal State" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>100</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[03 26] - Thermal State" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
          </LN>
          <LN desc="Trip on reclose protection" lnType="PSOF_MULTI_OP" inst="1" lnClass="PSOF" prefix="Tor">
            <DOI name="Beh">
              <DAI desc="[FE 27] - TorPSOF.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[34 84] - TOR Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[34 84] - TOR Status" name="d" valKind="RO"/>
              <DAI name="lnNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op1">
              <DAI desc="DDB Ordinal: 704" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 704" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op2">
              <DAI desc="DDB Ordinal: 705" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 705" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op3">
              <DAI desc="DDB Ordinal: 706" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 706" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op4">
              <DAI desc="DDB Ordinal: 707" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 707" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op5">
              <DAI desc="DDB Ordinal: 708" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 708" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Op6">
              <DAI desc="DDB Ordinal: 557" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 557" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 878" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Compensated V1> 1 Overvoltage" lnType="PTOV_NO_SEG" inst="1" lnClass="PTOV" prefix="VtpCmp">
            <DOI name="Beh">
              <DAI desc="[FE 5A] - VtpCmpPTOV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 23] - V1>1 Cmp Funct" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 23] - V1>1 Cmp Funct" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 925" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 923" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Compensated V1> 2 Overvoltage" lnType="PTOV_NO_SEG" inst="2" lnClass="PTOV" prefix="VtpCmp">
            <DOI name="Beh">
              <DAI desc="[FE 5B] - VtpCmpPTOV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 27] - V1>2 Cmp Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 27] - V1>2 Cmp Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 926" name="general" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 924" name="general" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V> 1 Overvoltage" lnType="PTOV_SEG" inst="1" lnClass="PTOV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 10] - VtpPTOV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 10] - V>1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 10] - V>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 691" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 692" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 693" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 694" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 796" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 797" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 798" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 799" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V> 2 Overvoltage" lnType="PTOV_SEG" inst="2" lnClass="PTOV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 11] - VtpPTOV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 14] - V>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 14] - V>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 695" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 696" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 697" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 698" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 800" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 801" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 802" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 803" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V&lt; 1 Undervoltage" lnType="PTUV_SEG" inst="1" lnClass="PTUV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 12] - VtpPTUV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 04] - V&lt;1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 04] - V&lt;1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 683" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 684" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 685" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 686" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 788" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 789" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 790" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 791" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="V&lt; 2 Undervoltage" lnType="PTUV_SEG" inst="2" lnClass="PTUV" prefix="VtpPhs">
            <DOI name="Beh">
              <DAI desc="[FE 13] - VtpPTUV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[42 09] - V&lt;2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[42 09] - V&lt;2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 687" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 688" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 689" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 690" name="phsC" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsA" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsB" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirPhsC" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 792" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 793" name="phsA" valKind="RO"/>
              <DAI desc="DDB Ordinal: 794" name="phsB" valKind="RO"/>
              <DAI desc="DDB Ordinal: 795" name="phsC" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="VN> 1 Residual Overvoltage" lnType="PTOV_NEU" inst="1" lnClass="PTOV" prefix="VtpRes">
            <DOI name="Beh">
              <DAI desc="[FE 14] - NvdPTOV1.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3B 02] - VN>1 Function" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3B 02] - VN>1 Function" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 700" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 700" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 804" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 804" name="neut" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="VN> 2 Residual Overvoltage" lnType="PTOV_NEU" inst="2" lnClass="PTOV" prefix="VtpRes">
            <DOI name="Beh">
              <DAI desc="[FE 15] - NvdPTOV2.ST.Beh.stVal" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[3B 07] - VN>2 Status" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[3B 07] - VN>2 Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Op">
              <DAI desc="DDB Ordinal: 701" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 701" name="neut" valKind="RO"/>
            </DOI>
            <DOI name="Str">
              <DAI name="dirGeneral" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI name="dirNeut" valKind="RO">
                <Val>unknown</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 805" name="general" valKind="RO"/>
              <DAI desc="DDB Ordinal: 805" name="neut" valKind="RO"/>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="Records Domain" inst="Records">
          <LN0 desc="Records Logical Device" lnType="LLN0_STANDARD" inst="" lnClass="LLN0">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>Records Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN0>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Disturbance Recorder" lnType="RDRE_BASIC" inst="1" lnClass="RDRE">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FltNum">
              <DAI name="stVal" valKind="RO">
                <Val>0</Val>
              </DAI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Disturbance Recorder Function</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="RcdMade">
              <DAI desc="Returns if a Disturbance Record is available for Extraction." name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Fault Locator" lnType="RFLO_BASIC" inst="1" lnClass="RFLO">
            <Private type="MiCOM-ConfigurableAttributes">FltZ.db,FltZ.units.multiplier,FltZ.rangeC.min.f,FltZ.rangeC.max.f,FltDiskm.db,FltDiskm.rangeC.min.f,FltDiskm.rangeC.max.f,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="FltDiskm">
              <DAI name="db" valKind="Set">
                <Val>10</Val>
              </DAI>
              <SDI name="mag">
                <DAI desc="[01 13] - Fault Location (metres)" name="f" valKind="RO"/>
              </SDI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1000</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="RO">
                  <Val>k</Val>
                </DAI>
                <DAI desc="[01 13] - Fault Location (metres)" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="FltZ">
              <SDI name="cVal">
                <SDI name="mag">
                  <DAI desc="[01 15] - Fault Location (impedance)" name="f" valKind="RO"/>
                </SDI>
              </SDI>
              <DAI name="db" valKind="Set">
                <Val>1000</Val>
              </DAI>
              <SDI name="rangeC">
                <SDI name="hhLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="hLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="lLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="llLim">
                  <DAI name="f" valKind="RO">
                    <Val>0</Val>
                  </DAI>
                </SDI>
                <SDI name="max">
                  <DAI name="f" valKind="Set">
                    <Val>1000</Val>
                  </DAI>
                </SDI>
                <SDI name="min">
                  <DAI name="f" valKind="Set">
                    <Val>0</Val>
                  </DAI>
                </SDI>
              </SDI>
              <SDI name="units">
                <DAI name="multiplier" valKind="Set">
                  <Val></Val>
                </DAI>
                <DAI desc="[01 15] - Fault Location (impedance)" name="SIUnit" valKind="RO"/>
              </SDI>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Fault Locator Function</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
        </LDevice>
        <LDevice desc="System Domain" inst="System">
          <LN0 desc="System Logical Device" lnType="LLN0_SYSTEM$_b0106a33-fe12-4478-a126-452a9b390db5" inst="" lnClass="LLN0">
            <Private type="MiCOM-ConfigurableAttributes">LEDRs.ctlModel,LEDRs.sboTimeout,</Private>
            <DataSet name="ds_brcb1">
              <Private source="1704789725685" type="HELINKS_TAG"/>
              <FCDA doName="Op" fc="ST" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH"/>
              <FCDA doName="Str" fc="ST" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH"/>
            </DataSet>
            <DataSet name="ds_urcb1">
              <Private source="1704789725685" type="HELINKS_TAG"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Overcurrent" lnClass="TCTR" lnInst="5" prefix="A"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Overcurrent" lnClass="TCTR" lnInst="1" prefix="B"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Overcurrent" lnClass="TCTR" lnInst="4" prefix="C"/>
              <FCDA doName="AmpSv" fc="MX" ldInst="Overcurrent" lnClass="TCTR" lnInst="6" prefix="N"/>
            </DataSet>
            <DataSet name="ds_gcb_f1">
              <Private source="1704789725804" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="Op" fc="ST" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH"/>
              <FCDA daName="q" doName="Op" fc="ST" ldInst="Overcurrent" lnClass="PTOC" lnInst="1" prefix="PH"/>
            </DataSet>
            <ReportControl datSet="ds_urcb1" name="urcbA" intgPd="100" buffered="false" bufTime="100" confRev="10000" indexed="false" rptID="E01BUPSystem/LLN0.urcbA">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1">
                <ClientLN apRef="S1" iedName="Zenon" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl name="urcbB" intgPd="100" buffered="false" bufTime="100" confRev="0" indexed="false" rptID="E01BUPSystem/LLN0.urcbB">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="urcbC" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbC">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="urcbD" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbD">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbE" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbE">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbF" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbF">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbG" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbG">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbH" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbH">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbI" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbI">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbJ" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbJ">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbK" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbK">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbL" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbL">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbM" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbM">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbN" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbN">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbO" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbO">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="urcbP" intgPd="3000" buffered="false" bufTime="0" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.urcbP">
              <TrgOps dchg="true" dupd="false" gi="true" period="true" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl datSet="ds_brcb1" name="brcbA" intgPd="100" buffered="true" bufTime="100" confRev="10000" indexed="false" rptID="E01BUPSystem/LLN0.brcbA">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1">
                <ClientLN apRef="AP1" iedName="XPG" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="brcbB" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbB">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="brcbC" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbC">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="Created by HELINKS STS" name="brcbD" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbD">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbE" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbE">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbF" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbF">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbG" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbG">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <ReportControl desc="System Logical Device Report Control Block" name="brcbH" intgPd="0" buffered="true" bufTime="100" confRev="0" indexed="true" rptID="E01BUPSystem/LLN0.brcbH">
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1"/>
            </ReportControl>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="LEDRs">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="[01 FF] - Reset Indication" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="Returns config revision" name="configRev" valKind="RO"/>
              <DAI name="d" valKind="RO">
                <Val>System Logical Device</Val>
              </DAI>
              <DAI name="ldNs" valKind="RO">
                <Val>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="OrdRun">
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="Order Running indication" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SyncSt">
              <DAI name="dataNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-4:2003</Val>
              </DAI>
              <DAI desc="IED time synchronisation state" name="stVal" valKind="RO"/>
            </DOI>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_f1" name="gcb01" confRev="10000" appID="E01BUPSystem/LLN0gcb01" securityEnable="None">
              <IEDName apRef="SAM600ServerModel" ldInst="LD0" lnClass="PTRC" lnInst="1" prefix="Trip">E01PIU</IEDName>
            </GSEControl>
            <GSEControl name="gcb02" confRev="0" appID="E01BUPSystem/LLN0gcb02" securityEnable="None"/>
            <GSEControl name="gcb03" confRev="0" appID="E01BUPSystem/LLN0gcb03" securityEnable="None"/>
            <GSEControl name="gcb04" confRev="0" appID="E01BUPSystem/LLN0gcb04" securityEnable="None"/>
            <GSEControl name="gcb05" confRev="0" appID="E01BUPSystem/LLN0gcb05" securityEnable="None"/>
            <GSEControl name="gcb06" confRev="0" appID="E01BUPSystem/LLN0gcb06" securityEnable="None"/>
            <GSEControl name="gcb07" confRev="0" appID="E01BUPSystem/LLN0gcb07" securityEnable="None"/>
            <GSEControl name="gcb08" confRev="0" appID="E01BUPSystem/LLN0gcb08" securityEnable="None"/>
            <SettingControl actSG="1" numOfSGs="4"/>
          </LN0>
          <LN desc="Alarms" lnType="GGIO_ALM_96" inst="1" lnClass="GGIO" prefix="Alm">
            <DOI name="Alm1">
              <DAI desc="DDB Ordinal: 288" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 288" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm10">
              <DAI desc="DDB Ordinal: 297" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 297" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm11">
              <DAI desc="DDB Ordinal: 298" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 298" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm12">
              <DAI desc="DDB Ordinal: 299" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 299" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm13">
              <DAI desc="DDB Ordinal: 300" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 300" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm14">
              <DAI desc="DDB Ordinal: 301" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 301" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm15">
              <DAI desc="DDB Ordinal: 302" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 302" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm16">
              <DAI desc="DDB Ordinal: 303" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 303" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm17">
              <DAI desc="DDB Ordinal: 304" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 304" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm18">
              <DAI desc="DDB Ordinal: 305" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 305" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm19">
              <DAI desc="DDB Ordinal: 306" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 306" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm2">
              <DAI desc="DDB Ordinal: 289" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 289" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm20">
              <DAI desc="DDB Ordinal: 307" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 307" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm21">
              <DAI desc="DDB Ordinal: 308" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 308" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm22">
              <DAI desc="DDB Ordinal: 309" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 309" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm23">
              <DAI desc="DDB Ordinal: 310" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 310" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm24">
              <DAI desc="DDB Ordinal: 311" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 311" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm25">
              <DAI desc="DDB Ordinal: 312" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 312" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm26">
              <DAI desc="DDB Ordinal: 313" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 313" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm27">
              <DAI desc="DDB Ordinal: 314" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 314" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm28">
              <DAI desc="DDB Ordinal: 315" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 315" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm29">
              <DAI desc="DDB Ordinal: 316" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 316" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm3">
              <DAI desc="DDB Ordinal: 290" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 290" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm30">
              <DAI desc="DDB Ordinal: 317" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 317" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm31">
              <DAI desc="DDB Ordinal: 318" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 318" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm32">
              <DAI desc="DDB Ordinal: 319" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 319" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm33">
              <DAI desc="DDB Ordinal: 320" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 320" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm34">
              <DAI desc="DDB Ordinal: 321" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 321" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm35">
              <DAI desc="DDB Ordinal: 322" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 322" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm36">
              <DAI desc="DDB Ordinal: 323" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 323" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm37">
              <DAI desc="DDB Ordinal: 324" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 324" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm38">
              <DAI desc="DDB Ordinal: 325" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 325" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm39">
              <DAI desc="DDB Ordinal: 326" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 326" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm4">
              <DAI desc="DDB Ordinal: 291" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 291" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm40">
              <DAI desc="DDB Ordinal: 327" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 327" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm41">
              <DAI desc="DDB Ordinal: 328" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 328" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm42">
              <DAI desc="DDB Ordinal: 329" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 329" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm43">
              <DAI desc="DDB Ordinal: 330" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 330" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm44">
              <DAI desc="DDB Ordinal: 331" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 331" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm45">
              <DAI desc="DDB Ordinal: 332" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 332" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm46">
              <DAI desc="DDB Ordinal: 333" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 333" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm47">
              <DAI desc="DDB Ordinal: 334" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 334" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm48">
              <DAI desc="DDB Ordinal: 335" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 335" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm49">
              <DAI desc="DDB Ordinal: 336" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 336" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm5">
              <DAI desc="DDB Ordinal: 292" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 292" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm50">
              <DAI desc="DDB Ordinal: 337" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 337" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm51">
              <DAI desc="DDB Ordinal: 338" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 338" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm52">
              <DAI desc="DDB Ordinal: 339" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 339" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm53">
              <DAI desc="DDB Ordinal: 340" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 340" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm54">
              <DAI desc="DDB Ordinal: 341" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 341" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm55">
              <DAI desc="DDB Ordinal: 342" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 342" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm56">
              <DAI desc="DDB Ordinal: 343" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 343" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm57">
              <DAI desc="DDB Ordinal: 344" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 344" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm58">
              <DAI desc="DDB Ordinal: 345" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 345" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm59">
              <DAI desc="DDB Ordinal: 346" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 346" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm6">
              <DAI desc="DDB Ordinal: 293" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 293" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm60">
              <DAI desc="DDB Ordinal: 347" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 347" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm61">
              <DAI desc="DDB Ordinal: 348" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 348" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm62">
              <DAI desc="DDB Ordinal: 349" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 349" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm63">
              <DAI desc="DDB Ordinal: 350" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 350" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm64">
              <DAI desc="DDB Ordinal: 351" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 351" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm65">
              <DAI desc="DDB Ordinal: 352" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 352" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm66">
              <DAI desc="DDB Ordinal: 353" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 353" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm67">
              <DAI desc="DDB Ordinal: 354" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 354" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm68">
              <DAI desc="DDB Ordinal: 355" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 355" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm69">
              <DAI desc="DDB Ordinal: 356" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 356" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm7">
              <DAI desc="DDB Ordinal: 294" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 294" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm70">
              <DAI desc="DDB Ordinal: 357" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 357" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm71">
              <DAI desc="DDB Ordinal: 358" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 358" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm72">
              <DAI desc="DDB Ordinal: 359" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 359" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm73">
              <DAI desc="DDB Ordinal: 360" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 360" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm74">
              <DAI desc="DDB Ordinal: 361" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 361" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm75">
              <DAI desc="DDB Ordinal: 362" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 362" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm76">
              <DAI desc="DDB Ordinal: 363" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 363" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm77">
              <DAI desc="DDB Ordinal: 364" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 364" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm78">
              <DAI desc="DDB Ordinal: 365" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 365" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm79">
              <DAI desc="DDB Ordinal: 366" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 366" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm8">
              <DAI desc="DDB Ordinal: 295" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 295" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm80">
              <DAI desc="DDB Ordinal: 367" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 367" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm81">
              <DAI desc="DDB Ordinal: 368" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 368" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm82">
              <DAI desc="DDB Ordinal: 369" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 369" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm83">
              <DAI desc="DDB Ordinal: 370" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 370" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm84">
              <DAI desc="DDB Ordinal: 371" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 371" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm85">
              <DAI desc="DDB Ordinal: 372" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 372" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm86">
              <DAI desc="DDB Ordinal: 373" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 373" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm87">
              <DAI desc="DDB Ordinal: 374" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 374" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm88">
              <DAI desc="DDB Ordinal: 375" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 375" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm89">
              <DAI desc="DDB Ordinal: 376" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 376" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm9">
              <DAI desc="DDB Ordinal: 296" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 296" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm90">
              <DAI desc="DDB Ordinal: 377" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 377" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm91">
              <DAI desc="DDB Ordinal: 378" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 378" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm92">
              <DAI desc="DDB Ordinal: 379" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 379" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm93">
              <DAI desc="DDB Ordinal: 380" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 380" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm94">
              <DAI desc="DDB Ordinal: 381" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 381" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm95">
              <DAI desc="DDB Ordinal: 382" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 382" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Alm96">
              <DAI desc="DDB Ordinal: 383" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 383" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Alarm Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Function Keys" lnType="GGIO_IND_10" inst="1" lnClass="GGIO" prefix="Fnk">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="[17 04] - Fn Key 1 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1096" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="[17 1F] - Fn Key 10 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1105" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="[17 07] - Fn Key 2 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1097" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="[17 0A] - Fn Key 3 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1098" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="[17 0D] - Fn Key 4 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1099" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="[17 10] - Fn Key 5 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1100" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="[17 13] - Fn Key 6 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1101" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="[17 16] - Fn Key 7 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1102" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="[17 19] - Fn Key 8 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1103" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="[17 1C] - Fn Key 9 Label" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1104" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[17 01] - Fn Key Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="GOOSE Input Signals" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="Gos">
            <Private type="MiCOM-BindableType">VI</Private>
            <Private type="MiCOM-BindableSignals">
									Ind1.stVal,
									Ind2.stVal,
									Ind3.stVal,
									Ind4.stVal,
									Ind5.stVal,
									Ind6.stVal,
									Ind7.stVal,
									Ind8.stVal,
									Ind9.stVal,
									Ind10.stVal,
									Ind11.stVal,
									Ind12.stVal,
									Ind13.stVal,
									Ind14.stVal,
									Ind15.stVal,
									Ind16.stVal,
									Ind17.stVal,
									Ind18.stVal,
									Ind19.stVal,
									Ind20.stVal,
									Ind21.stVal,
									Ind22.stVal,
									Ind23.stVal,
									Ind24.stVal,
									Ind25.stVal,
									Ind26.stVal,
									Ind27.stVal,
									Ind28.stVal,
									Ind29.stVal,
									Ind30.stVal,
									Ind31.stVal,
									Ind32.stVal,
						</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 224" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 224" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 233" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 233" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 234" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 234" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 235" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 235" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 236" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 236" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 237" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 237" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 238" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 238" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 239" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 239" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 240" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 240" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 241" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 241" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="DDB Ordinal: 242" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 242" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 225" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 225" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="DDB Ordinal: 243" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 243" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="DDB Ordinal: 244" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 244" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="DDB Ordinal: 245" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 245" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="DDB Ordinal: 246" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 246" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="DDB Ordinal: 247" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 247" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="DDB Ordinal: 248" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 248" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="DDB Ordinal: 249" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 249" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="DDB Ordinal: 250" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 250" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="DDB Ordinal: 251" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 251" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="DDB Ordinal: 252" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 252" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 226" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 226" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="DDB Ordinal: 253" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 253" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="DDB Ordinal: 254" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 254" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="DDB Ordinal: 255" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 255" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 227" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 227" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 228" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 228" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 229" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 229" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 230" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 230" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 231" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 231" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 232" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 232" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>GOOSE Input Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" prefix="A" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="I1 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" prefix="A" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" prefix="B" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="I2 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" prefix="B" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" prefix="C" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="I3 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" prefix="C" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" prefix="N" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="I Neut sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" prefix="N" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN desc="GOOSE Output Signals" lnType="GGIO_IND_32" inst="2" lnClass="GGIO" prefix="Gos">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 256" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 256" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 265" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 265" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 266" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 266" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 267" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 267" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 268" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 268" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 269" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 269" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 270" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 270" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 271" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 271" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 272" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 272" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 273" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 273" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="DDB Ordinal: 274" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 274" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 257" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 257" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="DDB Ordinal: 275" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 275" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="DDB Ordinal: 276" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 276" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="DDB Ordinal: 277" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 277" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="DDB Ordinal: 278" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 278" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="DDB Ordinal: 279" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 279" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="DDB Ordinal: 280" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 280" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="DDB Ordinal: 281" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 281" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="DDB Ordinal: 282" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 282" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="DDB Ordinal: 283" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 283" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="DDB Ordinal: 284" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 284" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 258" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 258" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="DDB Ordinal: 285" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 285" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="DDB Ordinal: 286" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 286" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="DDB Ordinal: 287" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 287" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 259" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 259" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 260" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 260" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 261" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 261" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 262" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 262" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 263" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 263" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 264" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 264" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>GOOSE Output Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Inputs Status (CH1)" lnType="GGIO_IND_8" inst="1" lnClass="GGIO" prefix="ImfInp">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 96" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 96" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 97" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 97" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 98" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 98" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 99" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 99" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 100" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 100" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 101" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 101" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 102" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 102" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 103" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 103" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 1 Fibre InterMiCOM Inputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Inputs Status (CH2)" lnType="GGIO_IND_8" inst="2" lnClass="GGIO" prefix="ImfInp">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 104" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 104" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 105" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 105" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 106" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 106" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 107" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 107" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 108" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 108" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 109" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 109" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 110" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 110" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 111" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 111" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 2 Fibre InterMiCOM Inputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Outputs Status (CH1)" lnType="GGIO_IND_8" inst="1" lnClass="GGIO" prefix="ImfOut">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 112" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 112" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 113" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 113" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 114" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 114" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 115" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 115" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 116" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 116" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 117" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 117" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 118" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 118" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 119" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 119" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 1 Fibre InterMiCOM Outputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="InterMiCOM Fibre Outputs Status (CH2)" lnType="GGIO_IND_8" inst="2" lnClass="GGIO" prefix="ImfOut">
            <DOI name="Beh">
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 120" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 120" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 121" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 121" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 122" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 122" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 123" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 123" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 124" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 124" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 125" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 125" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 126" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 126" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 127" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 127" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[09 41] - InterMiCOM 64" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Channel 2 Fibre InterMiCOM Outputs</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Red LED Signals" lnType="GGIO_IND_18" inst="1" lnClass="GGIO" prefix="Led">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 1024" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1024" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 1042" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1042" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 1044" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1044" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 1046" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1046" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 1048" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1048" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 1050" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1050" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 1052" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1052" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 1054" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1054" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 1056" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1056" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 1058" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1058" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 1026" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1026" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 1028" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1028" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 1030" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1030" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 1032" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1032" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 1034" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1034" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 1036" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1036" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 1038" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1038" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 1040" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1040" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Red LED Signals</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Green LED Signals" lnType="GGIO_IND_18" inst="2" lnClass="GGIO" prefix="Led">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="DDB Ordinal: 1025" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1025" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="DDB Ordinal: 1043" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1043" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="DDB Ordinal: 1045" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1045" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="DDB Ordinal: 1047" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1047" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="DDB Ordinal: 1049" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1049" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="DDB Ordinal: 1051" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1051" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="DDB Ordinal: 1053" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1053" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="DDB Ordinal: 1055" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1055" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="DDB Ordinal: 1057" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1057" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="DDB Ordinal: 1059" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1059" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="DDB Ordinal: 1027" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1027" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="DDB Ordinal: 1029" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1029" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="DDB Ordinal: 1031" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1031" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="DDB Ordinal: 1033" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1033" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="DDB Ordinal: 1035" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1035" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="DDB Ordinal: 1037" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1037" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="DDB Ordinal: 1039" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1039" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="DDB Ordinal: 1041" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1041" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>Green LED Signals</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Physical Device Information" lnType="LPHD_STANDARD" inst="1" lnClass="LPHD">
            <DOI name="PhyHealth">
              <DAI desc="Returns the Health of the Physical Device." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="PhyNam">
              <DAI desc="Returns the Hardware Revision of the Physical Device." name="hwRev" valKind="RO"/>
              <DAI desc="[00 05] - Plant Reference" name="location" valKind="RO"/>
              <DAI desc="[00 06] - Model Number" name="model" valKind="RO"/>
              <DAI desc="[00 08] - Serial Number" name="serNum" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="Proxy">
              <DAI name="d" valKind="RO">
                <Val>Logical Device is a Proxy</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="PwrUp">
              <DAI name="d" valKind="RO">
                <Val>Px40 Power-Up Detected</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>true</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Opto (32) Inputs" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="Opt">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="[4A 01] - Opto Input 1" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 32" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="[4A 0A] - Opto Input 10" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 41" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="[4A 0B] - Opto Input 11" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 42" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="[4A 0C] - Opto Input 12" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 43" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="[4A 0D] - Opto Input 13" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 44" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="[4A 0E] - Opto Input 14" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 45" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="[4A 0F] - Opto Input 15" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 46" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="[4A 10] - Opto Input 16" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 47" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="[4A 11] - Opto Input 17" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 48" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="[4A 12] - Opto Input 18" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 49" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="[4A 13] - Opto Input 19" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 50" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="[4A 02] - Opto Input 2" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 33" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="[4A 14] - Opto Input 20" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 51" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="[4A 15] - Opto Input 21" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 52" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="[4A 16] - Opto Input 22" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 53" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="[4A 17] - Opto Input 23" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 54" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="[4A 18] - Opto Input 24" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 55" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="[4A 19] - Opto Input 25" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 56" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="[4A 1A] - Opto Input 26" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 57" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="[4A 1B] - Opto Input 27" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 58" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="[4A 1C] - Opto Input 28" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 59" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="[4A 1D] - Opto Input 29" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 60" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="[4A 03] - Opto Input 3" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 34" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="[4A 1E] - Opto Input 30" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 61" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="[4A 1F] - Opto Input 31" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 62" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="[4A 20] - Opto Input 32" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 63" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="[4A 04] - Opto Input 4" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 35" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="[4A 05] - Opto Input 5" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 36" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="[4A 06] - Opto Input 6" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 37" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="[4A 07] - Opto Input 7" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 38" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="[4A 08] - Opto Input 8" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 39" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="[4A 09] - Opto Input 9" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 40" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[0F 01] - Opto I/P Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Uniqueness of control &quot;Order Running&quot; indications for Control operations" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="OrdRun">
            <Private type="MiCOM-BindableType">OrdRun</Private>
            <Private type="MiCOM-BindableSignals">
									Ind1.stVal,
									Ind2.stVal,
									Ind3.stVal,
									Ind4.stVal,
									Ind5.stVal,
									Ind6.stVal,
									Ind7.stVal,
									Ind8.stVal,
									Ind9.stVal,
									Ind10.stVal,
									Ind11.stVal,
									Ind12.stVal,
									Ind13.stVal,
									Ind14.stVal,
									Ind15.stVal,
									Ind16.stVal,
									Ind17.stVal,
									Ind18.stVal,
									Ind19.stVal,
									Ind20.stVal,
									Ind21.stVal,
									Ind22.stVal,
									Ind23.stVal,
									Ind24.stVal,
									Ind25.stVal,
									Ind26.stVal,
									Ind27.stVal,
									Ind28.stVal,
									Ind29.stVal,
									Ind30.stVal,
									Ind31.stVal,
									Ind32.stVal,
						</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind10">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind11">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind12">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind13">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind14">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind15">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind16">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind17">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind18">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind19">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind2">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind20">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind21">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind22">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind23">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind24">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind25">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind26">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind27">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind28">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind29">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind3">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind30">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind31">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind32">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind4">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind5">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind6">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind7">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind8">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Ind9">
              <DAI name="d" valKind="RO">
                <Val>External device order running indication</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>false</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>GOOSE Input Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="Controllable Inputs" lnType="GGIO_IND_32_CTRL$_0e905083-6669-49f3-9a2f-73b59cb0dd7f" inst="1" lnClass="GGIO" prefix="Plo">
            <Private type="MiCOM-ConfigurableAttributes">SPCSO1.ctlModel,SPCSO1.sboTimeout,SPCSO2.ctlModel,SPCSO2.sboTimeout,SPCSO3.ctlModel,SPCSO3.sboTimeout,SPCSO4.ctlModel,SPCSO4.sboTimeout,SPCSO5.ctlModel,SPCSO5.sboTimeout,SPCSO6.ctlModel,SPCSO6.sboTimeout,SPCSO7.ctlModel,SPCSO7.sboTimeout,SPCSO8.ctlModel,SPCSO8.sboTimeout,SPCSO9.ctlModel,SPCSO9.sboTimeout,SPCSO10.ctlModel,SPCSO10.sboTimeout,SPCSO11.ctlModel,SPCSO11.sboTimeout,SPCSO12.ctlModel,SPCSO12.sboTimeout,SPCSO13.ctlModel,SPCSO13.sboTimeout,SPCSO14.ctlModel,SPCSO14.sboTimeout,SPCSO15.ctlModel,SPCSO15.sboTimeout,SPCSO16.ctlModel,SPCSO16.sboTimeout,SPCSO17.ctlModel,SPCSO17.sboTimeout,SPCSO18.ctlModel,SPCSO18.sboTimeout,SPCSO19.ctlModel,SPCSO19.sboTimeout,SPCSO20.ctlModel,SPCSO20.sboTimeout,SPCSO21.ctlModel,SPCSO21.sboTimeout,SPCSO22.ctlModel,SPCSO22.sboTimeout,SPCSO23.ctlModel,SPCSO23.sboTimeout,SPCSO24.ctlModel,SPCSO24.sboTimeout,SPCSO25.ctlModel,SPCSO25.sboTimeout,SPCSO26.ctlModel,SPCSO26.sboTimeout,SPCSO27.ctlModel,SPCSO27.sboTimeout,SPCSO28.ctlModel,SPCSO28.sboTimeout,SPCSO29.ctlModel,SPCSO29.sboTimeout,SPCSO30.ctlModel,SPCSO30.sboTimeout,SPCSO31.ctlModel,SPCSO31.sboTimeout,SPCSO32.ctlModel,SPCSO32.sboTimeout,</Private>
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[12 01] - Ctrl I/P Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
            <DOI name="SPCSO1">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 192" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO10">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 201" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO11">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 202" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO12">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 203" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO13">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 204" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO14">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 205" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO15">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 206" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO16">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 207" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO17">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 208" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO18">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 209" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO19">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 210" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO2">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 193" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO20">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 211" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO21">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 212" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO22">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 213" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO23">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 214" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO24">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 215" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO25">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 216" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO26">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 217" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO27">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 218" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO28">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 219" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO29">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 220" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO3">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 194" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO30">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 221" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO31">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 222" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO32">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 223" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO4">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 195" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO5">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 196" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO6">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 197" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO7">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 198" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO8">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 199" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="SPCSO9">
              <DAI name="cdcName" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="cdcNs" valKind="RO">
                <Val>ALSTOM-SII:PCS-Px40>IEC 61850-7-3:2003</Val>
              </DAI>
              <DAI name="ctlModel" valKind="Set">
                <Val>status-only</Val>
              </DAI>
              <SDI name="origin">
                <DAI name="orCat" valKind="RO">
                  <Val>process</Val>
                </DAI>
                <DAI name="orIdent" valKind="RO"/>
              </SDI>
              <DAI name="sboTimeout" valKind="Set">
                <Val>30000</Val>
              </DAI>
              <DAI desc="DDB Ordinal: 200" name="stVal" valKind="RO"/>
            </DOI>
          </LN>
          <LN desc="Output Contacts" lnType="GGIO_IND_32" inst="1" lnClass="GGIO" prefix="Rly">
            <DOI name="Beh">
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Ind1">
              <DAI desc="[4B 01] - Relay 1" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 0" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind10">
              <DAI desc="[4B 0A] - Relay 10" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 9" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind11">
              <DAI desc="[4B 0B] - Relay 11" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 10" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind12">
              <DAI desc="[4B 0C] - Relay 12" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 11" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind13">
              <DAI desc="[4B 0D] - Relay 13" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 12" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind14">
              <DAI desc="[4B 0E] - Relay 14" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 13" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind15">
              <DAI desc="[4B 0F] - Relay 15" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 14" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind16">
              <DAI desc="[4B 10] - Relay 16" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 15" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind17">
              <DAI desc="[4B 11] - Relay 17" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 16" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind18">
              <DAI desc="[4B 12] - Relay 18" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 17" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind19">
              <DAI desc="[4B 13] - Relay 19" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 18" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind2">
              <DAI desc="[4B 02] - Relay 2" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind20">
              <DAI desc="[4B 14] - Relay 20" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 19" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind21">
              <DAI desc="[4B 15] - Relay 21" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 20" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind22">
              <DAI desc="[4B 16] - Relay 22" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 21" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind23">
              <DAI desc="[4B 17] - Relay 23" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 22" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind24">
              <DAI desc="[4B 18] - Relay 24" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 23" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind25">
              <DAI desc="[4B 19] - Relay 25" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 24" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind26">
              <DAI desc="[4B 1A] - Relay 26" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 25" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind27">
              <DAI desc="[4B 1B] - Relay 27" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 26" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind28">
              <DAI desc="[4B 1C] - Relay 28" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 27" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind29">
              <DAI desc="[4B 1D] - Relay 29" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 28" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind3">
              <DAI desc="[4B 03] - Relay 3" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind30">
              <DAI desc="[4B 1E] - Relay 30" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 29" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind31">
              <DAI desc="[4B 1F] - Relay 31" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 30" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind32">
              <DAI desc="[4B 20] - Relay 32" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 31" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind4">
              <DAI desc="[4B 04] - Relay 4" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 3" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind5">
              <DAI desc="[4B 05] - Relay 5" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 4" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind6">
              <DAI desc="[4B 06] - Relay 6" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 5" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind7">
              <DAI desc="[4B 07] - Relay 7" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 6" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind8">
              <DAI desc="[4B 08] - Relay 8" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 7" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Ind9">
              <DAI desc="[4B 09] - Relay 9" name="d" valKind="RO"/>
              <DAI desc="DDB Ordinal: 8" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI desc="[0F 0D] - Test Mode" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="NamPlt">
              <DAI desc="[0F 02] - Relay O/P Status" name="d" valKind="RO"/>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
          <LN desc="User Mapped (PSL) Double Point Status Indications" lnType="GGIO_IND_DPS_8" inst="1" lnClass="GGIO" prefix="Usr">
            <DOI name="Beh">
              <DAI desc="Determines the Mode/Behaviour of the Device based on the 'Test Mode' DDB." name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO1">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 1</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 1" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO2">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 2</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 2" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO3">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 3</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 3" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO4">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 4</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 4" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO5">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 5</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 5" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO6">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 6</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 6" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO7">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 7</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 7" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="DPCSO8">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status 8</Val>
              </DAI>
              <DAI desc="Returns the Status of the User Status DDBs For DPS status input 8" name="stVal" valKind="RO"/>
            </DOI>
            <DOI name="Health">
              <DAI name="stVal" valKind="RO">
                <Val>Ok</Val>
              </DAI>
            </DOI>
            <DOI name="Mod">
              <DAI name="ctlModel" valKind="RO">
                <Val>status-only</Val>
              </DAI>
              <DAI name="stVal" valKind="RO">
                <Val>on</Val>
              </DAI>
            </DOI>
            <DOI name="NamPlt">
              <DAI name="d" valKind="RO">
                <Val>User Double Point Status</Val>
              </DAI>
              <DAI desc="[00 11] - Software Ref. 1" name="swRev" valKind="RO"/>
              <DAI name="vendor" valKind="RO">
                <Val>MiCOM</Val>
              </DAI>
            </DOI>
          </LN>
        </LDevice>
      </Server>
    </AccessPoint>
    <AccessPoint name="AP2"/>
  </IED>
  <IED desc="-W001 Leitung Tamina Ost" configVersion="V07.31.03" manufacturer="SIEMENS" type="6MD86" name="E01BCU">
    <Private type="Siemens-MasterId">ccbaddd5-6978-458d-8717-387707226c37</Private>
    <Private type="Siemens-s7ManagerName">-W001 Leitung Tamina Ost</Private>
    <Private type="Siemens-ICD-Language">de-DE</Private>
    <Private type="Siemens-Siprotec5-Product-Code">6MD86-DAAA-AA0-0AAAA0-AA0112-43111B-BAA000-000AA0-CB3BA1-CG0CG0-CG0</Private>
    <Private type="Siemens-Siprotec5-Application-Template">6MD86_NotConfigured</Private>
    <Private type="Siemens-Siprotec5-Communication-Configuration-Version">73100</Private>
    <Private type="Siemens-Siprotec5-Configuration-Version">V07.31.03</Private>
    <Private type="Siemens-IsSiprotec5IED"/>
    <Services nameLength="64">
      <DynAssociation/>
      <SettingGroups>
        <SGEdit/>
      </SettingGroups>
      <GetDirectory/>
      <GetDataObjectDefinition/>
      <DataObjectDirectory/>
      <GetDataSetValue/>
      <DataSetDirectory/>
      <ConfDataSet max="50" maxAttributes="60"/>
      <DynDataSet max="30" maxAttributes="60"/>
      <ReadWrite/>
      <ConfReportControl max="30"/>
      <GetCBValues/>
      <ReportSettings cbName="Conf" datSet="Dyn" bufTime="Dyn" intgPd="Dyn" optFields="Dyn" rptID="Dyn" trgOps="Dyn"/>
      <GSESettings cbName="Conf" datSet="Conf" appID="Conf" dataLabel="Fix"/>
      <GOOSE max="16"/>
      <FileHandling/>
      <ConfLNs fixLnInst="false" fixPrefix="false"/>
      <ClientServices bufReport="false" goose="true" supportsLdName="true" sv="true"/>
    </Services>
    <AccessPoint desc="Port E" clock="false" router="false" name="E">
      <Server timeout="0">
        <Private type="Siemens-MasterId">cd2ea416-c82e-4893-8eda-8c1e02c31ce6</Private>
        <Authentication none="true"/>
        <LDevice inst="Measurement" ldName="CardiffETransformerMeasurement">
          <LN0 lnType="lln0_7_4_B2007" inst="" lnClass="LLN0">
            <DataSet name="ds_brcb1">
              <Private source="1704789725686" type="HELINKS_TAG"/>
              <FCDA doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="OpIn" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="Str" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="OpCls" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="OpOpn" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="Pos" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="OpCls" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA doName="OpOpn" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA doName="Pos" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
            </DataSet>
            <DataSet name="ds_brcb2">
              <Private source="1704789725687" type="HELINKS_TAG"/>
              <FCDA doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="OpIn" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="Str" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA doName="OpCls" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="OpOpn" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="Pos" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA doName="OpCls" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA doName="OpOpn" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA doName="Pos" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
            </DataSet>
            <DataSet name="ds_urcb1">
              <Private source="1704789725687" type="HELINKS_TAG"/>
              <FCDA doName="A" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A"/>
              <FCDA doName="PhV" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V"/>
            </DataSet>
            <DataSet name="ds_urcb2">
              <Private source="1704789725688" type="HELINKS_TAG"/>
              <FCDA doName="A" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="1" prefix="A"/>
              <FCDA doName="PhV" fc="MX" ldInst="Measurement" lnClass="MMXU" lnInst="2" prefix="V"/>
            </DataSet>
            <DataSet name="ds_gcb_f1">
              <Private source="1704789725805" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA daName="q" doName="OpEx" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA daName="general" doName="OpIn" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
              <FCDA daName="q" doName="OpIn" fc="ST" ldInst="BreakerFailure1" lnClass="RBRF" lnInst="1" prefix=""/>
            </DataSet>
            <DataSet name="ds_gcb_l1">
              <Private source="1704789725805" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="OpCls" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA daName="q" doName="OpCls" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA daName="general" doName="OpOpn" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
              <FCDA daName="q" doName="OpOpn" fc="ST" ldInst="QA0Control" lnClass="CSWI" lnInst="2" prefix="QA0"/>
            </DataSet>
            <DataSet name="ds_gcb_l2">
              <Private source="1704789725805" type="HELINKS_TAG"/>
              <FCDA daName="general" doName="OpCls" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA daName="q" doName="OpCls" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA daName="general" doName="OpOpn" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
              <FCDA daName="q" doName="OpOpn" fc="ST" ldInst="QB1Control" lnClass="CSWI" lnInst="1" prefix="QB1"/>
            </DataSet>
            <ReportControl datSet="ds_brcb1" name="brcba" intgPd="100" buffered="true" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.brcba">
              <Private source="1704789725686" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1704789725686" type="HELINKS_TAG"/>
                <ClientLN apRef="S1" iedName="Zenon" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="ds_brcb2" name="brcbb" intgPd="100" buffered="true" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.brcbb">
              <Private source="1704789725687" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields bufOvfl="true" configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="true" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1704789725687" type="HELINKS_TAG"/>
                <ClientLN apRef="AP1" iedName="XPG" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="ds_urcb1" name="urcba" intgPd="100" buffered="false" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.urcba">
              <Private source="1704789725687" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1704789725687" type="HELINKS_TAG"/>
                <ClientLN apRef="S1" iedName="Zenon" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <ReportControl datSet="ds_urcb2" name="urcbb" intgPd="100" buffered="false" bufTime="100" confRev="10000" indexed="false" rptID="E01BCUMeasurement/LLN0.urcbb">
              <Private source="1704789725688" type="HELINKS_TAG"/>
              <TrgOps dchg="true" dupd="false" gi="true" period="false" qchg="true"/>
              <OptFields configRef="true" dataRef="false" dataSet="true" entryID="false" reasonCode="false" seqNum="false" timeStamp="true"/>
              <RptEnabled max="1">
                <Private source="1704789725688" type="HELINKS_TAG"/>
                <ClientLN apRef="AP1" iedName="XPG" ldInst="LD0" prefix="" lnClass="ITCI" lnInst="1"/>
              </RptEnabled>
            </ReportControl>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.NamPlt.desc" name="NamPlt">
              <DAI name="paramRev" valKind="Set"/>
              <DAI name="valRev" valKind="Set"/>
              <DAI name="vendor" valKind="Set"/>
              <DAI name="swRev" valKind="Set"/>
              <DAI name="ldNs" valKind="Set"/>
              <DAI name="lnNs" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="configRev" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Beh.desc" name="Beh">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Health.desc" name="Health">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocKey.desc" name="LocKey">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Loc.desc" name="Loc">
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Mod.desc" name="Mod">
              <DAI name="blkEna" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="q" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LocSta.desc" name="LocSta">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.Diag.desc" name="Diag">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.LEDRs.desc" name="LEDRs">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.SwMod.desc" name="SwMod">
              <SDI name="origin">
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orCat.desc" name="orCat" valKind="Set"/>
                <DAI desc="IEC61850_7_2.DomainTypesGeneral::S_Originator.orIdent.desc" name="orIdent" valKind="Set"/>
              </SDI>
              <DAI name="ctlNum" valKind="Set"/>
              <DAI name="stVal" valKind="Set"/>
              <DAI name="q" valKind="Set"/>
              <DAI name="t" valKind="Set"/>
              <DAI name="stSeld" valKind="Set"/>
              <DAI name="opRcvd" valKind="Set"/>
              <DAI name="opOk" valKind="Set"/>
              <DAI name="tOpOk" valKind="Set"/>
              <DAI name="subEna" valKind="Set"/>
              <DAI name="subVal" valKind="Set"/>
              <DAI name="subQ" valKind="Set"/>
              <DAI name="subID" valKind="Set"/>
              <DAI name="blkEna" valKind="Set"/>
              <SDI name="pulseConfig">
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.cmdQual.desc" name="cmdQual" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.onDur.desc" name="onDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.offDur.desc" name="offDur" valKind="Set"/>
                <DAI desc="IEC61850_7_3.ConstructedDAs::PulseConfig.numPls.desc" name="numPls" valKind="Set"/>
              </SDI>
              <DAI name="ctlModel" valKind="Set"/>
              <DAI name="sboTimeout" valKind="Set"/>
              <DAI name="sboClass" valKind="Set"/>
              <DAI name="operTimeout" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.InRef.desc" name="InRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.GrRef.desc" name="GrRef">
              <DAI name="setSrcRef" valKind="Set"/>
              <DAI name="setTstRef" valKind="Set"/>
              <DAI name="setSrcCB" valKind="Set"/>
              <DAI name="setTstCB" valKind="Set"/>
              <DAI name="intAddr" valKind="Set"/>
              <DAI name="tstEna" valKind="Set"/>
              <DAI name="purpose" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <DOI desc="IEC61850_7_4.LNGroupL::LLN0.MltLev.desc" name="MltLev">
              <DAI name="setVal" valKind="Set"/>
              <DAI name="d" valKind="Set"/>
              <DAI name="dU" valKind="Set"/>
              <DAI name="cdcName" valKind="Set"/>
              <DAI name="dataNs" valKind="Set"/>
            </DOI>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_f1" name="gcb_f1" confRev="10000" appID="E01BCUMeasurement/LLN0gcb_f1" securityEnable="None">
              <Private source="1704789725805" type="HELINKS_TAG"/>
              <IEDName apRef="E" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E02PIU</IEDName>
              <IEDName apRef="E" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E05PIU</IEDName>
              <IEDName apRef="SAM600ServerModel" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E01PIU</IEDName>
            </GSEControl>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_l1" name="gcb_l1" confRev="10000" appID="E01BCUMeasurement/LLN0gcb_l1" securityEnable="None">
              <Private source="1704789725805" type="HELINKS_TAG"/>
              <IEDName apRef="SAM600ServerModel" ldInst="QA0Interface" lnClass="XCBR" lnInst="1" prefix="QA0">E01PIU</IEDName>
            </GSEControl>
            <GSEControl desc="Helinks default Goose Control Block" datSet="ds_gcb_l2" name="gcb_l2" confRev="10000" appID="E01BCUMeasurement/LLN0gcb_l2" securityEnable="None">
              <Private source="1704789725805" type="HELINKS_TAG"/>
              <IEDName apRef="SAM600ServerModel" ldInst="QB1Interface" lnClass="XSWI" lnInst="1" prefix="QB1">E01PIU</IEDName>
            </GSEControl>
          </LN0>
          <LN lnType="mmxu_7_4_B2007" inst="1" lnClass="MMXU" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupM::MMXU.A.desc" name="A">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="neut">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="mmxu_7_4_B2007" inst="2" lnClass="MMXU" prefix="V">
            <DOI desc="IEC61850_7_4.LNGroupM::MMXU.PhV.desc" name="PhV">
              <SDI name="phsA">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsB">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="phsC">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
              <SDI name="net">
                <SDI name="cVal">
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.mag.desc" name="mag">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                  <SDI desc="IEC61850_7_3.ConstructedDAs::Vector.ang.desc" name="ang">
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
                    <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
                  </SDI>
                </SDI>
              </SDI>
            </DOI>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="2" lnClass="TVTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="U1 sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" prefix="A" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="U1 sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="1" prefix="A" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="12" lnClass="TVTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="U2 sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" prefix="B" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="U2 sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="2" prefix="B" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="14" lnClass="TVTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="U3 sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" prefix="C" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="U3 sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="3" prefix="C" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN lnType="tvtr_7_4_B2007" inst="3" lnClass="TVTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TVTR.VolSv.desc" name="VolSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="U Neut sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" prefix="N" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="U Neut sv" doName="VolSv" iedName="E01PIU" ldInst="VTVT" lnClass="TVTR" lnInst="4" prefix="N" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="5" lnClass="TCTR" prefix="A">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="I1 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" prefix="A" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="I1 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="1" prefix="A" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="1" lnClass="TCTR" prefix="B">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.f.desc" name="f" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.f" desc="I2 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" prefix="B" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="I2 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="2" prefix="B" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="4" lnClass="TCTR" prefix="C">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="I3 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" prefix="C" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
              <ExtRef daName="q" desc="I3 sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="3" prefix="C" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
            </Inputs>
          </LN>
          <LN lnType="tctr_7_4_B2007" inst="6" lnClass="TCTR" prefix="N">
            <DOI desc="IEC61850_7_4.LNGroupT::TCTR.AmpSv.desc" name="AmpSv">
              <SDI name="instMag">
                <DAI desc="IEC61850_7_3.AnalogueValue::AnalogueValue.i.desc" name="i" valKind="Set"/>
              </SDI>
            </DOI>
            <Inputs>
              <ExtRef daName="instMag.i" desc="I Neut sv" doName="AmpSv" iedName="E01PIU" ldInst="CTCT" lnClass="TCTR" lnInst="4" prefix="N" serviceType="SMV" srcCBName="smvcba" srcLDInst="LD0" srcLNClass="LLN0"/>
